/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.action.log;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.HorseActionType;
import com.equestricraft.core.horse.action.log.HorseActionLog;
import java.util.List;

public class HorseActionLogDatabase
implements RepositoryDatasource<HorseActionLog, Long> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_ACTION_IDENTIFIER = "ACTION_IDENTIFIER";
    private static final String COLUMN_TIME_STAMP = "TIME_STAMP";

    @Override
    public void create(HorseActionLog horseActionLog) {
        Query.insertInto("HORSE_ACTION_LOG").columns(QueryColumn.column(COLUMN_HORSE_ID, horseActionLog.getHorseId()), QueryColumn.column(COLUMN_ACTION_IDENTIFIER, horseActionLog.getAction()), QueryColumn.column(COLUMN_TIME_STAMP, horseActionLog.getTimeStamp())).executeGetGeneratedKey(horseActionLog::setId);
    }

    @Override
    public List<HorseActionLog> retrieveAll() {
        return Query.selectAllFrom("HORSE_ACTION_LOG").getList(this::getFromResultRow);
    }

    private HorseActionLog getFromResultRow(ResultRow row) {
        long id = row.getLong(COLUMN_ID);
        int horseId = row.getInt(COLUMN_HORSE_ID);
        HorseActionType actionIdentifier = row.getEnum(COLUMN_ACTION_IDENTIFIER, HorseActionType.class);
        long timeStamp = row.getLong(COLUMN_TIME_STAMP);
        return new HorseActionLog(id, horseId, actionIdentifier, timeStamp);
    }
}

