/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.action.log;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.HorseActionType;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.action.log.HorseActionLog;
import com.equestricraft.core.horse.action.log.HorseActionLogDatabase;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class HorseActionLogRepository
extends Repository<HorseActionLog, Long> {
    @Service
    private HorseActionLogDatabase horseActionLogDatabase;

    @Override
    protected RepositoryDatasource<HorseActionLog, Long> getDatasource() {
        return this.horseActionLogDatabase;
    }

    @Override
    protected Function<HorseActionLog, Object> getIndexFunction() {
        return HorseActionLog::getHorseId;
    }

    public List<HorseActionLog> findByHorse(int horseId) {
        return this.findListByIndexKey(horseId);
    }

    public List<HorseActionLog> findActionsInPastDuration(int horseId, Duration duration) {
        List<HorseActionLog> list = this.findByHorse(horseId);
        return list.stream().filter(l -> DateUtils.durationSince(l.getTimeStamp()).toMillis() < duration.toMillis()).toList();
    }

    public Optional<HorseActionLog> findMostRecentByHorseAndAction(int horseId, HorseActionType actionType) {
        return this.createSearchQuery().filter(l -> l.getHorseId() == horseId).filter(l -> l.getAction().equals((Object)actionType)).sortReverse(HorseActionLog::getTimeStamp).single();
    }

    public List<HorseActionLog> findByHorseAndAction(int horseId, HorseActionType actionType) {
        return this.createSearchQuery().filter(l -> l.getHorseId() == horseId).filter(l -> l.getAction().equals((Object)actionType)).many();
    }
}

