/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.action.log;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.HorseActionType;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseSettings;
import com.equestricraft.core.horse.action.log.HorseActionLog;
import com.equestricraft.core.horse.action.log.HorseActionLogRepository;
import com.equestricraft.core.horse.action.log.HorseActionLogSession;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

public class HorseActionLogSessionImpl
implements HorseActionLogSession {
    @Service
    private HorseActionLogRepository horseActionLogRepository;

    @Override
    public void logAction(EQHorse horse, HorseActionType horseActionType) {
        HorseActionLog log = new HorseActionLog(0L, horse.getId(), horseActionType, System.currentTimeMillis());
        this.horseActionLogRepository.add(log);
    }

    @Override
    public List<HorseActionType> getRecentActions(EQHorse horse) {
        Duration duration = Duration.ofSeconds(HorseSettings.getRecentActionMemorySeconds());
        List<HorseActionLog> logs = this.horseActionLogRepository.findActionsInPastDuration(horse.getId(), duration);
        return logs.stream().map(HorseActionLog::getAction).distinct().toList();
    }

    @Override
    public Optional<Duration> getDurationSinceActionTypeLastPerformedForHorse(EQHorse horse, HorseActionType type) {
        return this.horseActionLogRepository.findMostRecentByHorseAndAction(horse.getId(), type).map(HorseActionLog::getTimeStamp).map(DateUtils::durationSince);
    }

    @Override
    public int getCountOfActionInPastDuration(EQHorse horse, HorseActionType type, Duration duration) {
        List<HorseActionLog> logs = this.horseActionLogRepository.findByHorseAndAction(horse.getId(), type);
        return Math.toIntExact(logs.stream().filter(l -> DateUtils.durationSince(l.getTimeStamp()).toMillis() <= duration.toMillis()).count());
    }

    @Override
    public int getCountOfAction(EQHorse horse, HorseActionType type) {
        List<HorseActionLog> logs = this.horseActionLogRepository.findByHorseAndAction(horse.getId(), type);
        return logs.size();
    }
}

