/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.age;

import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.age.HorseAgeSession;
import java.util.Date;

public class HorseAgeSessionImpl
implements HorseAgeSession {
    private static final double REAL_TIME_MONTH_DURATION = 2.5;

    @Override
    public double calculateAgeYears(EQHorse horse) {
        int months = this.calculateAgeMonths(horse);
        return (double)months / 12.0;
    }

    @Override
    public int calculateAgeMonths(EQHorse horse) {
        Date birthTime = horse.getBirthTime();
        return this.determineAgeMonthsFromBirthTime(birthTime);
    }

    @Override
    public int determineAgeMonthsFromBirthTime(Date birthTime) {
        int realTimeDays = DateUtils.daysSince(birthTime);
        return (int)((double)realTimeDays / 2.5);
    }

    @Override
    public Date determineBirthTimeFromAgeInMonths(int months) {
        double realTimeDays = (int)((double)months * 2.5);
        long millis = (long)(8.64E7 * realTimeDays);
        return DateUtils.futureMillisOffset(-millis);
    }

    @Override
    public String getHorseAgeString(EQHorse horse) {
        int ageMonths = this.calculateAgeMonths(horse);
        return this.formatAgeInMonths(ageMonths);
    }

    @Override
    public String formatAgeInMonths(int months) {
        int years = Math.floorDiv(months, 12);
        int remainingMonths = months % 12;
        return String.format("%sy %sm", years, remainingMonths);
    }
}

