/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.aggression;

import com.equestricraft.common.HorseGender;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.trait.Trait;
import com.equestricraft.core.horse.trait.TraitVisitor;
import com.equestricraft.featureflag.FeatureFlag;
import java.util.Optional;

public class AggressionTrait
implements Trait {
    @Override
    public float getValue(EQHorse horse) {
        Optional<Double> percentageThroughPregnancy;
        if (horse.getHorseGender() == HorseGender.MARE && (percentageThroughPregnancy = horse.getPregnancy().getPercentageThroughPregnancy()).isPresent()) {
            return percentageThroughPregnancy.get() >= 80.0 ? 1.0f : 0.0f;
        }
        float value = horse.getStress().getValue();
        if (FeatureFlag.MARE_HEAT.isEnabled() && horse.getBreeding().isInHeat()) {
            value *= 0.3f;
        }
        return value;
    }

    @Override
    public String getName() {
        return I18n.getLabel("horse.trait.aggression.name");
    }

    @Override
    public String getDescription() {
        return I18n.getLabel("horse.trait.aggression.description");
    }

    @Override
    public <T> T accept(TraitVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

