/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.attribute;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.cdi.Services;
import com.equestricraft.core.horse.attribute.HorseAttributeValueKey;
import com.equestricraft.core.horse.attribute.HorseAttributeValueRepository;
import java.util.Objects;

public class HorseAttributeValue
implements RepositoryEntity<HorseAttributeValueKey> {
    private final HorseAttributeValueKey key;
    private String value;

    public HorseAttributeValue(int horseId, int attributeId, String value) {
        this.key = new HorseAttributeValueKey(horseId, attributeId);
        this.value = value;
    }

    @Override
    public HorseAttributeValueKey getKey() {
        return this.key;
    }

    public int getHorseId() {
        return this.getKey().horseId();
    }

    public int getAttributeId() {
        return this.getKey().attributeId();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void save() {
        Services.getService(HorseAttributeValueRepository.class).update(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HorseAttributeValue that = (HorseAttributeValue)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }
}

