/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.attribute;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.horse.attribute.HorseAttributeValue;
import com.equestricraft.core.horse.attribute.HorseAttributeValueKey;
import java.util.List;

public class HorseAttributeValueDatabase
implements RepositoryDatasource<HorseAttributeValue, HorseAttributeValueKey> {
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_ATTRIBUTE_ID = "ATTRIBUTE_ID";
    private static final String COLUMN_VALUE = "VALUE";

    @Override
    public void create(HorseAttributeValue horseAttributeValue) {
        Query.insertInto("HORSE_ATTRIBUTE_VALUE").columns(QueryColumn.column(COLUMN_HORSE_ID, horseAttributeValue.getHorseId()), QueryColumn.column(COLUMN_ATTRIBUTE_ID, horseAttributeValue.getAttributeId()), QueryColumn.column(COLUMN_VALUE, horseAttributeValue.getValue())).execute();
    }

    @Override
    public List<HorseAttributeValue> retrieveAll() {
        return Query.selectAllFrom("HORSE_ATTRIBUTE_VALUE").getList(this::getFromResultRow);
    }

    private HorseAttributeValue getFromResultRow(ResultRow row) {
        int horseId = row.getInt(COLUMN_HORSE_ID);
        int attributeId = row.getInt(COLUMN_ATTRIBUTE_ID);
        String value = row.getNullableString(COLUMN_VALUE);
        return new HorseAttributeValue(horseId, attributeId, value);
    }

    @Override
    public void update(HorseAttributeValue horseAttributeValue) {
        Query.update("HORSE_ATTRIBUTE_VALUE").set(QueryColumn.column(COLUMN_VALUE, horseAttributeValue.getValue())).where(QueryColumn.column(COLUMN_HORSE_ID, horseAttributeValue.getHorseId()), QueryColumn.column(COLUMN_ATTRIBUTE_ID, horseAttributeValue.getAttributeId())).execute();
    }
}

