/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.attribute;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.attribute.horse.HorseAttribute;
import com.equestricraft.core.attribute.horse.HorseAttributeRepository;
import com.equestricraft.core.horse.APIHorseDtoImpl;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.attribute.HorseAttributeValue;
import com.equestricraft.core.horse.attribute.HorseAttributeValueKey;
import com.equestricraft.core.horse.attribute.HorseAttributeValueRepository;
import com.equestricraft.core.horse.attribute.HorseAttributeValueSession;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.executor.GroovyScriptResponse;
import com.equestricraft.groovy.executor.GroovyStandardScriptExecutor;
import com.equestricraft.logging.Log;
import java.util.Optional;

public class HorseAttributeValueSessionImpl
implements HorseAttributeValueSession {
    @Service
    private HorseAttributeValueRepository horseAttributeValueRepository;
    @Service
    private HorseAttributeRepository horseAttributeRepository;
    private static final String GROOVY_VARIABLE_VALUE = "value";
    private static final Log log = Log.getLogger(HorseAttributeValueSessionImpl.class.getName());

    @Override
    public void setAttributeValueForHorse(EQHorse horse, int attributeId, Object value) {
        String strValue = value != null ? value.toString() : null;
        Optional horseAttributeValueOptional = this.horseAttributeValueRepository.findByKeyIfExists(this.key(horse, attributeId));
        if (horseAttributeValueOptional.isPresent()) {
            HorseAttributeValue horseAttributeValue = (HorseAttributeValue)horseAttributeValueOptional.get();
            horseAttributeValue.setValue(strValue);
            horseAttributeValue.save();
        } else {
            HorseAttributeValue newValue = new HorseAttributeValue(horse.getId(), attributeId, strValue);
            this.horseAttributeValueRepository.add(newValue);
        }
    }

    @Override
    public void setAttributeValueForHorse(EQHorse horse, String attributeIdentifier, Object value) {
        HorseAttribute attribute = (HorseAttribute)this.horseAttributeRepository.findByIdentifier(attributeIdentifier);
        this.setAttributeValueForHorse(horse, attribute.getId(), value);
    }

    @Override
    public Optional<String> getAttributeValueForHorse(EQHorse horse, int attributeId) {
        return this.horseAttributeValueRepository.findByKeyIfExists(this.key(horse, attributeId)).map(HorseAttributeValue::getValue);
    }

    @Override
    public Optional<String> getAttributeValueForHorse(EQHorse horse, String attributeIdentifier) {
        HorseAttribute attribute = (HorseAttribute)this.horseAttributeRepository.findByIdentifier(attributeIdentifier);
        return this.getAttributeValueForHorse(horse, attribute.getId());
    }

    private HorseAttributeValueKey key(EQHorse horse, int attributeId) {
        return new HorseAttributeValueKey(horse.getId(), attributeId);
    }

    @Override
    public boolean isAttributeTrueForHorse(EQHorse horse, int attributeId) {
        HorseAttribute horseAttribute = (HorseAttribute)this.horseAttributeRepository.findByKey(attributeId);
        return this.isAttributeTrueForHorse(horse, horseAttribute);
    }

    @Override
    public boolean isAttributeTrueForHorse(EQHorse horse, String attributeIdentifier) {
        HorseAttribute horseAttribute = (HorseAttribute)this.horseAttributeRepository.findByIdentifier(attributeIdentifier);
        return this.isAttributeTrueForHorse(horse, horseAttribute);
    }

    private boolean isAttributeTrueForHorse(EQHorse horse, HorseAttribute attribute) {
        String value = this.getAttributeValueForHorse(horse, attribute.getId()).orElse(null);
        return this.executeTrueConditionScript(attribute, horse, value);
    }

    private boolean executeTrueConditionScript(HorseAttribute horseAttribute, EQHorse horse, String value) {
        APIHorseDtoImpl horseDto = new APIHorseDtoImpl(horse);
        try {
            GroovyScriptResponse response = ((GroovyStandardScriptExecutor)((GroovyStandardScriptExecutor)GroovyStandardScriptExecutor.start(horseAttribute.getTrueConditionScript()).withHorse(horseDto)).withVariable(GROOVY_VARIABLE_VALUE, value)).execute();
            Boolean result = (Boolean)response.result();
            return result != null && result != false;
        }
        catch (GroovyException ex) {
            log.error(String.format("Error executing script for attribute %s", horseAttribute.getName()), ex);
            return false;
        }
    }

    @Override
    public boolean isAttributeFalseForHorse(EQHorse horse, int attributeId) {
        return !this.isAttributeTrueForHorse(horse, attributeId);
    }

    @Override
    public boolean isAttributeFalseForHorse(EQHorse horse, String attributeIdentifier) {
        return !this.isAttributeTrueForHorse(horse, attributeIdentifier);
    }

    @Override
    public String getAttributeDisplayValueForHorse(EQHorse horse, int attributeId) {
        HorseAttribute attribute = (HorseAttribute)this.horseAttributeRepository.findByKey(attributeId);
        return this.getAttributeDisplayValueForHorse(horse, attribute);
    }

    @Override
    public String getAttributeDisplayValueForHorse(EQHorse horse, String attributeIdentifier) {
        HorseAttribute attribute = (HorseAttribute)this.horseAttributeRepository.findByIdentifier(attributeIdentifier);
        return this.getAttributeDisplayValueForHorse(horse, attribute);
    }

    private String getAttributeDisplayValueForHorse(EQHorse horse, HorseAttribute attribute) {
        String value = this.getAttributeValueForHorse(horse, attribute.getId()).orElse(null);
        return this.executeDisplayScript(attribute, horse, value);
    }

    private String executeDisplayScript(HorseAttribute horseAttribute, EQHorse horse, String value) {
        APIHorseDtoImpl horseDto = new APIHorseDtoImpl(horse);
        try {
            GroovyScriptResponse response = ((GroovyStandardScriptExecutor)((GroovyStandardScriptExecutor)GroovyStandardScriptExecutor.start(horseAttribute.getDisplayScript()).withHorse(horseDto)).withVariable(GROOVY_VARIABLE_VALUE, value)).execute();
            if (response != null) {
                return response.toString();
            }
            return "";
        }
        catch (GroovyException ex) {
            log.error(String.format("Error executing script for attribute %s", horseAttribute.getName()), ex);
            return "";
        }
    }
}

