/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.attribute;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.attribute.AttributeAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.attribute.HorseAttributeValueAccessor;
import com.equestricraft.core.horse.attribute.HorseAttributeValueSession;
import java.util.Optional;

public class HorseAttributesAccessor
extends AttributeAccessor {
    @Service
    private static HorseAttributeValueSession horseAttributeValueSession;
    private final EQHorse horse;

    public HorseAttributesAccessor(EQHorse horse) {
        this.horse = horse;
    }

    @Override
    public Object get(Object key) {
        Optional<String> value = horseAttributeValueSession.getAttributeValueForHorse(this.horse, key.toString());
        return new HorseAttributeValueAccessor(value.orElse(null));
    }

    @Override
    public Object put(String key, Object value) {
        String strVal = HorseAttributeValueAccessor.parseAttributeValue(value);
        horseAttributeValueSession.setAttributeValueForHorse(this.horse, key, (Object)strVal);
        return value;
    }

    @Override
    public boolean isTrue(Object key) {
        return horseAttributeValueSession.isAttributeTrueForHorse(this.horse, key.toString());
    }

    @Override
    public String getDisplayValue(Object key) {
        return horseAttributeValueSession.getAttributeDisplayValueForHorse(this.horse, key.toString());
    }
}

