/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.bit;

import com.equestricraft.api.common.APIBitDto;
import com.equestricraft.api.common.APIHorseBitDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.bit.HorseBit;
import com.equestricraft.core.bit.HorseBitTransformer;
import com.equestricraft.core.horse.bit.HorseBitAccessor;

public class APIHorseBitDtoImpl
implements APIHorseBitDto {
    private final HorseBit horseBit;
    private final HorseBitAccessor horseBitAccessor;
    @Service
    private static HorseBitTransformer horseBitTransformer;

    public APIHorseBitDtoImpl(HorseBit horseBit, HorseBitAccessor horseBitAccessor) {
        this.horseBit = horseBit;
        this.horseBitAccessor = horseBitAccessor;
    }

    @Override
    public APIBitDto getBit() {
        return horseBitTransformer.toApiDto(this.horseBit);
    }

    @Override
    public Double getEffectivenessPercentage() {
        return (double)this.getEffectiveness().floatValue() * 100.0;
    }

    @Override
    public Float getEffectiveness() {
        return this.horseBitAccessor.getEffectiveness().orElseThrow();
    }

    public String toString() {
        return this.getBit().toString();
    }
}

