/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.bit;

import com.equestricraft.api.common.APIBitDto;
import com.equestricraft.api.common.APIHorseBitDto;
import com.equestricraft.api.common.APIHorseBitsDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.bit.HorseBit;
import com.equestricraft.core.bit.HorseBitTransformer;
import com.equestricraft.core.horse.bit.APIHorseBitDtoImpl;
import com.equestricraft.core.horse.bit.HorseBitAccessor;
import com.equestricraft.core.horse.bit.HorseBitException;

public class APIHorseBitsDtoImpl
implements APIHorseBitsDto {
    private final HorseBitAccessor horseBitAccessor;
    @Service
    private static HorseBitTransformer horseBitTransformer;

    public APIHorseBitsDtoImpl(HorseBitAccessor horseBitAccessor) {
        this.horseBitAccessor = horseBitAccessor;
    }

    @Override
    public void set(APIBitDto bit) {
        HorseBit b = horseBitTransformer.fromDto(bit);
        try {
            this.horseBitAccessor.setBit(b);
        }
        catch (HorseBitException horseBitException) {
            // empty catch block
        }
    }

    @Override
    public APIHorseBitDto getCurrent() {
        return this.horseBitAccessor.getBit().map(b -> new APIHorseBitDtoImpl((HorseBit)b, this.horseBitAccessor)).orElse(null);
    }

    @Override
    public void repair() {
        try {
            this.horseBitAccessor.repairBit();
        }
        catch (HorseBitException horseBitException) {
            // empty catch block
        }
    }

    @Override
    public void remove() {
        try {
            this.horseBitAccessor.removeBit();
        }
        catch (HorseBitException horseBitException) {
            // empty catch block
        }
    }
}

