/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.bit;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.bit.HorseBit;
import com.equestricraft.core.bit.HorseBitRepository;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.action.ActionReaction;
import com.equestricraft.core.horse.bit.BitFitAction;
import com.equestricraft.core.horse.bit.BitInformation;
import com.equestricraft.core.horse.bit.BitRemoveAction;
import com.equestricraft.core.horse.bit.HorseBitException;
import java.util.Optional;

public class HorseBitAccessor
extends AbstractHorseAccessor {
    @Service
    private static HorseBitRepository horseBitRepository;

    public HorseBitAccessor(EQHorse horse) {
        super(horse);
    }

    public void setBit(HorseBit bit) throws HorseBitException {
        if (this.horse.getBitId() != null) {
            throw new HorseBitException(I18n.getLabel("horse-bit.has-bit-on-already"));
        }
        Object result = this.horse.getActions().processAction(new BitFitAction(this.horse, bit));
        if (((ActionReaction)result).isRejectAction()) {
            throw new HorseBitException(I18n.getLabel("horse-bit.rejected"));
        }
    }

    public Optional<HorseBit> getBit() {
        if (this.horse.getBitId() == null) {
            return Optional.empty();
        }
        HorseBit bit = (HorseBit)horseBitRepository.findByKey(this.horse.getBitId());
        return Optional.ofNullable(bit);
    }

    public Optional<Float> getEffectiveness() {
        Optional<HorseBit> bit = this.getBit();
        if (bit.isPresent()) {
            float effectiveness = this.calculateBitEffectiveness(bit.get());
            return Optional.of(Float.valueOf(effectiveness));
        }
        return Optional.empty();
    }

    private float calculateBitEffectiveness(HorseBit bit) {
        long totalBitDuration = (long)bit.getDurationDays() * 86400000L;
        long millisLeft = DateUtils.millisUntil(this.horse.getBitEndTime());
        double durationPercentageLeft = (double)millisLeft / (double)totalBitDuration * 100.0;
        if (durationPercentageLeft > 50.0) {
            return 1.0f;
        }
        return (float)(durationPercentageLeft * 2.0) / 100.0f;
    }

    public void repairBit() throws HorseBitException {
        if (this.horse.getBitEndTime() == null) {
            throw new HorseBitException(I18n.getLabel("horse-bit.no-bit-on"));
        }
        HorseBit bit = (HorseBit)horseBitRepository.findByKey(this.horse.getBitId());
        this.horse.setBitEndTime(bit.getMaximumEndTimeFromNow());
        this.horse.save();
    }

    public void removeBit() throws HorseBitException {
        if (this.horse.getBitId() == null) {
            throw new HorseBitException(I18n.getLabel("horse-bit.no-bit-on"));
        }
        this.horse.getActions().processAction(new BitRemoveAction(this.horse));
    }

    public Optional<BitInformation> getBitInformation() {
        Optional<HorseBit> bit = this.getBit();
        if (bit.isEmpty()) {
            return Optional.empty();
        }
        HorseBit b = bit.get();
        double percentage = (double)this.calculateBitEffectiveness(b) * 100.0;
        BitInformation info2 = new BitInformation(b.getId(), b.getName(), percentage);
        return Optional.of(info2);
    }
}

