/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.blood;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.blood.BloodType;
import com.equestricraft.core.blood.BloodTypeRepository;
import com.equestricraft.core.blood.BloodUnit;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.blood.BloodPressureReading;
import com.equestricraft.core.horse.blood.HorseBloodSession;

public class HorseBloodAccessor
extends AbstractHorseAccessor {
    @Service
    private static BloodTypeRepository bloodTypeRepository;
    @Service
    private static HorseBloodSession horseBloodSession;

    public HorseBloodAccessor(EQHorse horse) {
        super(horse);
    }

    public BloodType getType() {
        return (BloodType)bloodTypeRepository.findByKey(this.horse.getBloodTypeId());
    }

    public int getBloodUnitValue(BloodUnit unit) {
        return horseBloodSession.getHorsesBloodUnitValue(this.horse, unit);
    }

    public boolean getShouldTypeShowToPlayer() {
        return this.horse.isShowBloodTypeToPlayer();
    }

    public void setShouldTypeShowToPlayer(boolean shouldShow) {
        this.horse.setShowBloodTypeToPlayer(shouldShow);
        this.horse.save();
    }

    public BloodPressureReading getPressure() {
        return horseBloodSession.getHorsesPressure(this.horse);
    }
}

