/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.blood;

import com.equestricraft.cdi.Service;
import com.equestricraft.cdi.ServiceInstance;
import com.equestricraft.common.collector.ECCollectors;
import com.equestricraft.common.util.ListUtils;
import com.equestricraft.core.blood.BloodType;
import com.equestricraft.core.blood.BloodTypeRepository;
import com.equestricraft.core.blood.BloodUnit;
import com.equestricraft.core.blood.age.BloodAgeSetting;
import com.equestricraft.core.blood.age.BloodAgeSettingRepository;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.blood.BloodPressureReading;
import com.equestricraft.core.horse.blood.HorseBloodPressureProvider;
import com.equestricraft.core.horse.blood.HorseBloodSession;
import com.equestricraft.core.horse.blood.HorseBloodUnitStatProvider;
import java.util.List;

public class HorseBloodSessionImpl
implements HorseBloodSession {
    @Service
    private BloodAgeSettingRepository bloodAgeSettingRepository;
    @Service
    private BloodTypeRepository bloodTypeRepository;
    @Service
    private ServiceInstance<HorseBloodPressureProvider> horseBloodPressureProviders;
    @Service
    private ServiceInstance<HorseBloodUnitStatProvider> horseBloodUnitStatProviders;

    @Override
    public BloodType determineBloodTypeForHorse(EQHorse horse) {
        if (horse.hasParents()) {
            return this.determineBloodTypeFromParents(horse);
        }
        return this.getRandomBloodType();
    }

    private BloodType determineBloodTypeFromParents(EQHorse horse) {
        EQHorse mother = horse.getMother().getEqHorse();
        EQHorse father = horse.getFather().getEqHorse();
        Integer bloodTypeId = ListUtils.getRandom(mother.getBloodTypeId(), father.getBloodTypeId());
        return (BloodType)this.bloodTypeRepository.findByKey(bloodTypeId);
    }

    private BloodType getRandomBloodType() {
        List bloodTypes = this.bloodTypeRepository.findAll();
        return ListUtils.getRandomWeightedItem(bloodTypes, BloodType::getPercentage);
    }

    @Override
    public int getHorsesBloodUnitValue(EQHorse horse, BloodUnit bloodUnit) {
        BloodAgeSetting ageSetting = this.bloodAgeSettingRepository.findFirstAgeSettingAboveAge(horse.getAge().getMonths());
        Float factor = this.horseBloodUnitStatProviders.stream().map(p -> Float.valueOf(p.getFactorForBloodUnit(horse, bloodUnit))).collect(ECCollectors.toCombinedFloatPercentage());
        return (int)((float)this.getValueForUnit(ageSetting, bloodUnit) * factor.floatValue());
    }

    private int getValueForUnit(BloodAgeSetting bloodAgeSetting, BloodUnit bloodUnit) {
        return switch (bloodUnit) {
            default -> throw new IncompatibleClassChangeError();
            case BloodUnit.RED_BLOOD_CELL -> bloodAgeSetting.getRedBloodCellValue();
            case BloodUnit.WHITE_BLOOD_CELL -> bloodAgeSetting.getWhiteBloodCellValue();
            case BloodUnit.PLATELETS -> bloodAgeSetting.getPlateletsValue();
            case BloodUnit.ELECTROLYTES -> bloodAgeSetting.getElectrolytesValue();
            case BloodUnit.ENZYMES -> bloodAgeSetting.getEnzymesValue();
            case BloodUnit.PROTEIN -> bloodAgeSetting.getProteinValue();
            case BloodUnit.OXYGEN -> bloodAgeSetting.getOxygenValue();
            case BloodUnit.CARBON_DIOXIDE -> bloodAgeSetting.getCarbonDioxideValue();
            case BloodUnit.NITROGEN -> bloodAgeSetting.getNitrogenValue();
        };
    }

    @Override
    public BloodPressureReading getHorsesPressure(EQHorse horse) {
        double systolic = 120.0;
        double diastolic = 70.0;
        for (HorseBloodPressureProvider provider : this.horseBloodPressureProviders) {
            systolic *= (double)provider.getSystolicFactor(horse);
            diastolic *= (double)provider.getDiastolicFactor(horse);
        }
        return new BloodPressureReading(systolic, diastolic);
    }
}

