/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.breed;

import com.equestricraft.api.common.APIBreedDto;
import com.equestricraft.api.common.APIHorseBreedDto;
import com.equestricraft.api.common.APIHorseBreedsDto;
import com.equestricraft.api.common.APIHorseClassifiedBreedsDto;
import com.equestricraft.api.common.APIHorseValidBreedsDto;
import com.equestricraft.core.breed.APIBreedDtoImpl;
import com.equestricraft.core.breed.Breed;
import com.equestricraft.core.horse.breed.APIHorseBreedDtoImpl;
import com.equestricraft.core.horse.breed.APIHorseClassifiedBreedsDtoImpl;
import com.equestricraft.core.horse.breed.APIHorseValidBreedsDtoImpl;
import com.equestricraft.core.horse.breed.HorseBreedAccessor;
import com.equestricraft.core.horse.breed.HorseBreedInfo;
import com.equestricraft.core.horse.breed.HorseBreedInfoDefinition;
import java.util.AbstractList;
import java.util.List;
import java.util.Map;

public class APIHorseBreedsDtoImpl
extends AbstractList<APIHorseBreedDto>
implements APIHorseBreedsDto {
    private final HorseBreedAccessor horseBreedAccessor;
    private List<HorseBreedInfo> allBreeds = null;

    public APIHorseBreedsDtoImpl(HorseBreedAccessor horseBreedAccessor) {
        this.horseBreedAccessor = horseBreedAccessor;
    }

    @Override
    public boolean classify(Map<APIBreedDto, Double> breeds) {
        List<HorseBreedInfo> infoList = breeds.entrySet().stream().map(e -> {
            Breed breed = ((APIBreedDtoImpl)e.getKey()).getBreed();
            Double percentage = (Double)e.getValue();
            return new HorseBreedInfoDefinition(breed, percentage);
        }).toList();
        return this.horseBreedAccessor.classify(infoList);
    }

    @Override
    public APIHorseClassifiedBreedsDto getClassified() {
        this.ensureBreedsLoaded();
        return new APIHorseClassifiedBreedsDtoImpl(this.allBreeds);
    }

    @Override
    public boolean isPure() {
        return this.horseBreedAccessor.isPureBreed();
    }

    @Override
    public boolean isCross() {
        return this.horseBreedAccessor.isCrossBreed();
    }

    @Override
    public boolean isClassified() {
        return this.horseBreedAccessor.isClassified();
    }

    @Override
    public String getDisplayString() {
        return this.horseBreedAccessor.getDisplayString();
    }

    @Override
    public APIHorseValidBreedsDto getValid() {
        return new APIHorseValidBreedsDtoImpl(this.horseBreedAccessor);
    }

    @Override
    public APIHorseBreedDto get(int index) {
        this.ensureBreedsLoaded();
        HorseBreedInfo breed = this.allBreeds.get(index);
        return new APIHorseBreedDtoImpl(breed);
    }

    @Override
    public int size() {
        this.ensureBreedsLoaded();
        return this.allBreeds.size();
    }

    private void ensureBreedsLoaded() {
        if (this.allBreeds == null) {
            this.allBreeds = this.horseBreedAccessor.getBreeds();
        }
    }

    @Override
    public String toString() {
        return this.getDisplayString();
    }
}

