/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.breed;

import com.equestricraft.api.common.APIBreedDto;
import com.equestricraft.api.common.APIHorseBreedDto;
import com.equestricraft.api.common.APIHorseClassifiedBreedsDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.MapAdapter;
import com.equestricraft.core.breed.APIBreedDtoImpl;
import com.equestricraft.core.breed.Breed;
import com.equestricraft.core.breed.BreedRepository;
import com.equestricraft.core.horse.breed.APIHorseBreedDtoImpl;
import com.equestricraft.core.horse.breed.HorseBreedInfo;
import java.util.List;

public class APIHorseClassifiedBreedsDtoImpl
extends MapAdapter<APIBreedDto, APIHorseBreedDto>
implements APIHorseClassifiedBreedsDto {
    private final List<HorseBreedInfo> breeds;
    @Service
    private static BreedRepository breedRepository;

    public APIHorseClassifiedBreedsDtoImpl(List<HorseBreedInfo> breeds) {
        this.breeds = breeds;
    }

    @Override
    public APIHorseBreedDto get(Object key) {
        Breed breed = this.getFromKey(key);
        return this.breeds.stream().filter(b -> b.getBreed().equals(breed)).findFirst().map(APIHorseBreedDtoImpl::new).orElse(null);
    }

    private Breed getFromKey(Object key) {
        if (key instanceof String) {
            String identifier = (String)key;
            return breedRepository.findByIdentifier(identifier).orElseThrow();
        }
        if (key instanceof Integer) {
            Integer id = (Integer)key;
            return (Breed)breedRepository.findByKey(id);
        }
        if (key instanceof APIBreedDtoImpl) {
            APIBreedDtoImpl breedDto = (APIBreedDtoImpl)key;
            return breedDto.getBreed();
        }
        throw new IllegalArgumentException("Invalid key provided");
    }
}

