/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.breed;

import com.equestricraft.api.common.APIBreedDto;
import com.equestricraft.api.common.APIHorseValidBreedsDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.MapAdapter;
import com.equestricraft.core.breed.APIBreedDtoImpl;
import com.equestricraft.core.breed.Breed;
import com.equestricraft.core.breed.BreedRepository;
import com.equestricraft.core.breed.BreedTransformer;
import com.equestricraft.core.horse.breed.HorseBreedAccessor;

public class APIHorseValidBreedsDtoImpl
extends MapAdapter<String, APIBreedDto>
implements APIHorseValidBreedsDto {
    private final HorseBreedAccessor horseBreedAccessor;
    @Service
    private static BreedRepository breedRepository;
    @Service
    private static BreedTransformer breedTransformer;

    public APIHorseValidBreedsDtoImpl(HorseBreedAccessor horseBreedAccessor) {
        this.horseBreedAccessor = horseBreedAccessor;
    }

    @Override
    public APIBreedDto get(Object key) {
        Breed breed = this.getFromKey(key);
        if (this.horseBreedAccessor.isValidForBreed(breed)) {
            return breedTransformer.toDto(breed);
        }
        return null;
    }

    private Breed getFromKey(Object key) {
        if (key instanceof APIBreedDtoImpl) {
            APIBreedDtoImpl apiBreedDto = (APIBreedDtoImpl)key;
            return apiBreedDto.getBreed();
        }
        if (key instanceof String) {
            String identifier = (String)key;
            return breedRepository.findByIdentifier(identifier).orElseThrow();
        }
        if (key instanceof Integer) {
            Integer id = (Integer)key;
            return (Breed)breedRepository.findByKey(id);
        }
        throw new IllegalArgumentException("Invalid key provided");
    }
}

