/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.breed;

import com.equestricraft.common.ConformationCheckType;
import com.equestricraft.core.breed.Breed;
import com.equestricraft.core.breed.BreedConformationRating;
import com.equestricraft.core.conformation.check.ConformationRatingThresholdProvider;
import com.equestricraft.core.horse.EQHorse;
import java.util.List;
import java.util.function.ToDoubleFunction;

public class BreedConformationRatingProvider
implements ConformationRatingThresholdProvider {
    @Override
    public double getVeryGoodThreshold(ConformationCheckType type, EQHorse horse) {
        return this.getAverageThreshold(type, horse, BreedConformationRating::getVeryGoodThreshold);
    }

    @Override
    public double getGoodThreshold(ConformationCheckType type, EQHorse horse) {
        return this.getAverageThreshold(type, horse, BreedConformationRating::getGoodThreshold);
    }

    @Override
    public double getOkThreshold(ConformationCheckType type, EQHorse horse) {
        return this.getAverageThreshold(type, horse, BreedConformationRating::getOkThreshold);
    }

    @Override
    public double getPoorThreshold(ConformationCheckType type, EQHorse horse) {
        return this.getAverageThreshold(type, horse, BreedConformationRating::getPoorThreshold);
    }

    private double getAverageThreshold(ConformationCheckType conformationCheckType, EQHorse horse, ToDoubleFunction<BreedConformationRating> function) {
        List<Breed> breeds = horse.getBreed().getValidBreedsForHorse();
        return breeds.stream().flatMap(b -> b.getConformationRatings().stream()).filter(r -> r.getCheckType() == conformationCheckType).mapToDouble(function).average().orElse(0.0);
    }
}

