/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.breed;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.CachedValue;
import com.equestricraft.core.breed.Breed;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.breed.HorseBreed;
import com.equestricraft.core.horse.breed.HorseBreedException;
import com.equestricraft.core.horse.breed.HorseBreedInfo;
import com.equestricraft.core.horse.breed.HorseBreedInfoLookup;
import com.equestricraft.core.horse.breed.HorseBreedRepository;
import com.equestricraft.core.horse.breed.HorseBreedSession;
import com.equestricraft.core.horse.breed.HorseNotValidForBreedException;
import com.equestricraft.dataload.DataLoadModule;
import com.equestricraft.dataload.DataLoadSubscriber;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class HorseBreedAccessor
extends AbstractHorseAccessor {
    @Service
    private static HorseBreedSession horseBreedSession;
    @Service
    private static HorseBreedRepository horseBreedRepository;
    private static final DataLoadSubscriber breedUpdateSubscriber;
    private final CachedValue<String> displayString = new CachedValue<String>(this::getUpdatedDisplayString);
    private final CachedValue<Integer> classifiedBreedsCount = new CachedValue<Integer>(this::getUpdatedClassifiedBreedsCount);

    public HorseBreedAccessor(EQHorse horse) {
        super(horse);
        breedUpdateSubscriber.subscribe(this.displayString::expire);
    }

    public boolean classify(List<HorseBreedInfo> breeds) {
        try {
            for (HorseBreedInfo breed : breeds) {
                if (horseBreedSession.isBreedValid(this.horse, breed.getBreed())) continue;
                throw new HorseNotValidForBreedException();
            }
            List<HorseBreed> horseBreeds = breeds.stream().map(b -> new HorseBreed(this.horse.getId(), b.getBreed().getId(), b.getPercentage())).toList();
            horseBreedRepository.add(horseBreeds);
            this.displayString.expire();
            this.classifiedBreedsCount.expire();
            return true;
        }
        catch (HorseBreedException ex) {
            return false;
        }
    }

    public boolean isClassified() {
        return this.classifiedBreedsCount.get() > 0;
    }

    public boolean isPureBreed() {
        return this.classifiedBreedsCount.get() == 1;
    }

    public boolean isCrossBreed() {
        return this.classifiedBreedsCount.get() > 1;
    }

    public String getDisplayString() {
        return this.displayString.get();
    }

    public List<HorseBreedInfo> getBreeds() {
        List<HorseBreed> forHorse = horseBreedRepository.findBreedsByHorse(this.horse.getId());
        if (forHorse.isEmpty()) {
            return Collections.emptyList();
        }
        return forHorse.stream().map(h -> new HorseBreedInfoLookup(h.getBreed(), this)).toList();
    }

    public List<Breed> getValidBreedsForHorse() {
        return horseBreedSession.retrieveValidBreeds(this.horse);
    }

    public boolean isValidForBreed(Breed breed) {
        return horseBreedSession.isBreedValid(this.horse, breed);
    }

    public double getPercentageForBreed(Breed breed) {
        Optional<HorseBreed> horseBreed = horseBreedRepository.findByBreedAndHorse(breed.getId(), this.horse.getId());
        return horseBreed.map(HorseBreed::getPercentage).orElse(0.0);
    }

    private String getUpdatedDisplayString() {
        List<HorseBreedInfo> breeds = this.getBreeds();
        return breeds.stream().map(HorseBreedInfo::getBreed).map(Breed::getName).collect(Collectors.joining(", "));
    }

    private int getUpdatedClassifiedBreedsCount() {
        return this.getBreeds().size();
    }

    static {
        breedUpdateSubscriber = new DataLoadSubscriber(DataLoadModule.BREEDS);
    }
}

