/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.breed;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.horse.breed.HorseBreed;
import com.equestricraft.core.horse.breed.HorseBreedKey;
import java.util.List;

public class HorseBreedDatabase
implements RepositoryDatasource<HorseBreed, HorseBreedKey> {
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_BREED_ID = "BREED_ID";
    private static final String COLUMN_PERCENTAGE = "PERCENTAGE";

    @Override
    public void create(HorseBreed horseBreed) {
        Query.insertInto("HORSE_BREED").columns(QueryColumn.column(COLUMN_HORSE_ID, horseBreed.getHorseId()), QueryColumn.column(COLUMN_BREED_ID, horseBreed.getBreedId()), QueryColumn.column(COLUMN_PERCENTAGE, horseBreed.getPercentage())).execute();
    }

    @Override
    public List<HorseBreed> retrieveAll() {
        return Query.selectAllFrom("HORSE_BREED").getList(this::getFromResultRow);
    }

    private HorseBreed getFromResultRow(ResultRow row) {
        int horseId = row.getInt(COLUMN_HORSE_ID);
        int breedId = row.getInt(COLUMN_BREED_ID);
        double percentage = row.getDouble(COLUMN_PERCENTAGE);
        return new HorseBreed(horseId, breedId, percentage);
    }
}

