/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.breed;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.BreedCoatPolicy;
import com.equestricraft.common.HorseGender;
import com.equestricraft.common.Range;
import com.equestricraft.core.breed.Breed;
import com.equestricraft.core.breed.BreedColor;
import com.equestricraft.core.breed.BreedMarking;
import com.equestricraft.core.breed.BreedMarkingGroup;
import com.equestricraft.core.breed.BreedRepository;
import com.equestricraft.core.horse.APIHorseDtoImpl;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.breed.BreedEntity;
import com.equestricraft.core.horse.breed.HorseBreedSession;
import com.equestricraft.core.horse.coat.HorseCoatDetails;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.executor.GroovyRuleScriptExecutor;
import com.equestricraft.logging.Log;
import java.util.List;

public class HorseBreedSessionImpl
implements HorseBreedSession {
    @Service
    private BreedRepository breedRepository;
    private static final Log log = Log.getLogger(HorseBreedSessionImpl.class.getName());

    @Override
    public List<Breed> retrieveValidBreeds(BreedEntity breedEntity) {
        return this.breedRepository.streamAll().filter(b -> this.isBreedValid(breedEntity, (Breed)b)).toList();
    }

    @Override
    public boolean isBreedValid(BreedEntity breedEntity, Breed breed) {
        HorseCoatDetails coat = breedEntity.getCoatDetails();
        if (!this.doColorsMatchBreed(breed, coat)) {
            return false;
        }
        if (!this.doPatternsMatchBreed(breed, coat)) {
            return false;
        }
        if (!this.doPatternGroupsMatchBreed(breed, coat)) {
            return false;
        }
        if (!this.doesBaseHeightMatch(breed, breedEntity)) {
            return false;
        }
        if (!this.doesBaseWeightMatch(breed, breedEntity)) {
            return false;
        }
        if (breedEntity instanceof EQHorse) {
            EQHorse horse = (EQHorse)breedEntity;
            return this.doesConditionScriptPass(breed, horse);
        }
        return true;
    }

    private boolean doColorsMatchBreed(Breed breed, HorseCoatDetails coat) {
        for (BreedColor breedColor : breed.getColors()) {
            if (breedColor.getPolicy() == BreedCoatPolicy.REQUIRED && breedColor.getColor() != coat.getColor()) {
                return false;
            }
            if (breedColor.getPolicy() != BreedCoatPolicy.MUST_NOT_HAVE || breedColor.getColor() != coat.getColor()) continue;
            return false;
        }
        return true;
    }

    private boolean doPatternsMatchBreed(Breed breed, HorseCoatDetails coat) {
        for (BreedMarking breedMarking : breed.getMarkings()) {
            if (breedMarking.getPolicy() == BreedCoatPolicy.REQUIRED && !coat.getMarkings().contains((Object)breedMarking.getMarking())) {
                return false;
            }
            if (breedMarking.getPolicy() != BreedCoatPolicy.MUST_NOT_HAVE || !coat.getMarkings().contains((Object)breedMarking.getMarking())) continue;
            return false;
        }
        return true;
    }

    private boolean doPatternGroupsMatchBreed(Breed breed, HorseCoatDetails coat) {
        for (BreedMarkingGroup markingGroup : breed.getMarkingGroups()) {
            if (markingGroup.getPolicy() == BreedCoatPolicy.REQUIRED && coat.getMarkings().stream().noneMatch(m -> m.getGroup().equals((Object)markingGroup.getGroup()))) {
                return false;
            }
            if (markingGroup.getPolicy() != BreedCoatPolicy.MUST_NOT_HAVE || !coat.getMarkings().stream().anyMatch(m -> m.getGroup().equals((Object)markingGroup.getGroup()))) continue;
            return false;
        }
        return true;
    }

    private boolean doesBaseHeightMatch(Breed breed, BreedEntity breedEntity) {
        double heightBlocks = breedEntity.getBaseHeight().getValue().doubleValue();
        return Range.of(breed.getMinimumHeight(), breed.getMaximumHeight()).containsValueWithin(heightBlocks);
    }

    private boolean doesBaseWeightMatch(Breed breed, BreedEntity breedEntity) {
        Range<Double> range = switch (breedEntity.getHorseGender()) {
            default -> throw new IncompatibleClassChangeError();
            case HorseGender.STALLION, HorseGender.GELDING -> Range.of(breed.getStallionMinimumWeight(), breed.getStallionMaximumWeight());
            case HorseGender.MARE -> Range.of(breed.getMareMinimumWeight(), breed.getMareMaximumWeight());
        };
        return range.containsValueWithin(breedEntity.getBaseWeight().getValue().doubleValue());
    }

    private boolean doesConditionScriptPass(Breed breed, EQHorse horse) {
        if (breed.getConditionScript().isBlank()) {
            return true;
        }
        APIHorseDtoImpl h = new APIHorseDtoImpl(horse);
        try {
            return ((GroovyRuleScriptExecutor)GroovyRuleScriptExecutor.start(breed.getConditionScript()).withHorse(h)).execute().result().success();
        }
        catch (GroovyException ex) {
            log.error(String.format("Error executing condition script for breed %s", breed.getName()), ex);
            return false;
        }
    }
}

