/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.breeding;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.HorseBreedingAttemptResult;
import com.equestricraft.common.HorseGender;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.breeding.HorseBreedingAttemptSession;
import com.equestricraft.core.horse.pregnancy.PregnancySettings;
import com.equestricraft.featureflag.FeatureFlag;
import java.time.Duration;
import java.util.Optional;

public class HorseBreedingAccessor
extends AbstractHorseAccessor {
    @Service
    private static HorseBreedingAttemptSession horseBreedingAttemptSession;

    public HorseBreedingAccessor(EQHorse horse) {
        super(horse);
    }

    public Optional<Duration> getDurationSinceLastBreedingAttemptOnHorse(EQHorse otherHorse) {
        return horseBreedingAttemptSession.getDurationSinceLastBreedingAttemptOnHorse(this.horse, otherHorse);
    }

    public int getBreedingAttemptsInPastDuration(HorseBreedingAttemptResult result, Duration duration) {
        return horseBreedingAttemptSession.getBreedingAttemptsInPastDuration(this.horse, result, duration);
    }

    public int getTotalBreedingAttempts() {
        return horseBreedingAttemptSession.getTotalBreedingAttemptsForHorse(this.horse);
    }

    public Optional<Duration> getDurationSinceHorseLastHadBreedingAttempt() {
        return horseBreedingAttemptSession.getDurationSinceHorseLastInvolvedInBreedingAttempt(this.horse);
    }

    public boolean isInHeat() {
        if (this.horse.getHorseGender() != HorseGender.MARE) {
            return false;
        }
        if (FeatureFlag.MARE_HEAT.isDisabled()) {
            return true;
        }
        long daysSinceBirth = DateUtils.durationSince(this.horse.getBirthTime()).toDays();
        long daysInHeatCycle = daysSinceBirth % (long)PregnancySettings.getMareHeatCycleDurationDays().intValue();
        return daysInHeatCycle < (long)PregnancySettings.getMareHeatCycleDurationDays().intValue();
    }
}

