/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.breeding;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.cdi.Services;
import com.equestricraft.common.HorseBreedingAttemptResult;
import com.equestricraft.core.horse.breeding.HorseBreedingAttemptKey;
import com.equestricraft.core.horse.breeding.HorseBreedingAttemptRepository;
import java.util.Objects;

public class HorseBreedingAttempt
implements RepositoryEntity<HorseBreedingAttemptKey> {
    private final HorseBreedingAttemptKey key;
    private HorseBreedingAttemptResult result;
    private long timeStamp;

    public HorseBreedingAttempt(int horseId, int otherHorseId, HorseBreedingAttemptResult result, long timeStamp) {
        this.key = new HorseBreedingAttemptKey(horseId, otherHorseId);
        this.result = result;
        this.timeStamp = timeStamp;
    }

    @Override
    public HorseBreedingAttemptKey getKey() {
        return this.key;
    }

    public int getHorseId() {
        return this.getKey().horseId();
    }

    public int getOtherHorseId() {
        return this.getKey().otherHorseId();
    }

    public HorseBreedingAttemptResult getResult() {
        return this.result;
    }

    public void setResult(HorseBreedingAttemptResult result) {
        this.result = result;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Override
    public void save() {
        Services.getService(HorseBreedingAttemptRepository.class).update(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HorseBreedingAttempt that = (HorseBreedingAttempt)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }
}

