/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.breeding;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.HorseBreedingAttemptResult;
import com.equestricraft.core.horse.breeding.HorseBreedingAttempt;
import com.equestricraft.core.horse.breeding.HorseBreedingAttemptKey;
import java.util.List;

public class HorseBreedingAttemptDatabase
implements RepositoryDatasource<HorseBreedingAttempt, HorseBreedingAttemptKey> {
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_OTHER_HORSE_ID = "OTHER_HORSE_ID";
    private static final String COLUMN_RESULT = "RESULT";
    private static final String COLUMN_TIME_STAMP = "TIME_STAMP";

    @Override
    public void create(HorseBreedingAttempt horseBreedingAttempt) {
        Query.insertInto("HORSE_BREEDING_ATTEMPT").columns(QueryColumn.column(COLUMN_HORSE_ID, horseBreedingAttempt.getHorseId()), QueryColumn.column(COLUMN_OTHER_HORSE_ID, horseBreedingAttempt.getOtherHorseId()), QueryColumn.column(COLUMN_RESULT, horseBreedingAttempt.getResult()), QueryColumn.column(COLUMN_TIME_STAMP, horseBreedingAttempt.getTimeStamp())).execute();
    }

    @Override
    public List<HorseBreedingAttempt> retrieveAll() {
        return Query.selectAllFrom("HORSE_BREEDING_ATTEMPT").getList(this::getFromResultRow);
    }

    private HorseBreedingAttempt getFromResultRow(ResultRow row) {
        int horseId = row.getInt(COLUMN_HORSE_ID);
        int otherHorseId = row.getInt(COLUMN_OTHER_HORSE_ID);
        HorseBreedingAttemptResult result = row.getEnum(COLUMN_RESULT, HorseBreedingAttemptResult.class);
        long timeStamp = row.getLong(COLUMN_TIME_STAMP);
        return new HorseBreedingAttempt(horseId, otherHorseId, result, timeStamp);
    }

    @Override
    public void update(HorseBreedingAttempt horseBreedingAttempt) {
        Query.update("HORSE_BREEDING_ATTEMPT").set(QueryColumn.column(COLUMN_RESULT, horseBreedingAttempt.getResult()), QueryColumn.column(COLUMN_TIME_STAMP, horseBreedingAttempt.getTimeStamp())).where(QueryColumn.column(COLUMN_HORSE_ID, horseBreedingAttempt.getHorseId()), QueryColumn.column(COLUMN_OTHER_HORSE_ID, horseBreedingAttempt.getOtherHorseId())).execute();
    }
}

