/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.breeding;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositorySearchQuery;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.HorseBreedingAttemptResult;
import com.equestricraft.core.horse.breeding.HorseBreedingAttempt;
import com.equestricraft.core.horse.breeding.HorseBreedingAttemptDatabase;
import com.equestricraft.core.horse.breeding.HorseBreedingAttemptKey;
import java.util.Comparator;
import java.util.Optional;

public class HorseBreedingAttemptRepository
extends Repository<HorseBreedingAttempt, HorseBreedingAttemptKey> {
    @Service
    private HorseBreedingAttemptDatabase horseBreedingAttemptDatabase;

    @Override
    protected RepositoryDatasource<HorseBreedingAttempt, HorseBreedingAttemptKey> getDatasource() {
        return this.horseBreedingAttemptDatabase;
    }

    public Optional<HorseBreedingAttempt> findByHorseAndOtherHorse(int horseId, int otherHorseId) {
        return this.findByKeyIfExists(new HorseBreedingAttemptKey(horseId, otherHorseId));
    }

    public int findCountForHorseSince(int horseId, HorseBreedingAttemptResult result, long timeStamp) {
        RepositorySearchQuery<HorseBreedingAttempt> query = this.createSearchQuery();
        query.filter(a -> a.getHorseId() == horseId || a.getOtherHorseId() == horseId);
        query.filter(a -> a.getResult().equals((Object)result));
        query.filter(a -> a.getTimeStamp() >= timeStamp);
        return Math.toIntExact(query.count());
    }

    public int findCountForHorse(int horseId) {
        RepositorySearchQuery<HorseBreedingAttempt> query = this.createSearchQuery();
        query.filter(a -> a.getHorseId() == horseId || a.getOtherHorseId() == horseId);
        return Math.toIntExact(query.count());
    }

    public Optional<HorseBreedingAttempt> findByHorse(int horseId) {
        RepositorySearchQuery<HorseBreedingAttempt> searchQuery = this.createSearchQuery();
        searchQuery.filter(a -> a.getHorseId() == horseId || a.getOtherHorseId() == horseId);
        searchQuery.sortReverse(Comparator.comparingLong(HorseBreedingAttempt::getTimeStamp));
        return searchQuery.single();
    }
}

