/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.breeding;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.HorseBreedingAttemptResult;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.breeding.HorseBreedingAttempt;
import com.equestricraft.core.horse.breeding.HorseBreedingAttemptRepository;
import com.equestricraft.core.horse.breeding.HorseBreedingAttemptSession;
import java.time.Duration;
import java.util.Date;
import java.util.Optional;

public class HorseBreedingAttemptSessionImpl
implements HorseBreedingAttemptSession {
    @Service
    private HorseBreedingAttemptRepository horseBreedingAttemptRepository;

    @Override
    public void setBreedingAttemptForHorseOnHorse(EQHorse initiatingHorse, EQHorse targetedHorse, HorseBreedingAttemptResult result) {
        Optional<HorseBreedingAttempt> existing = this.horseBreedingAttemptRepository.findByHorseAndOtherHorse(initiatingHorse.getId(), targetedHorse.getId());
        if (existing.isPresent()) {
            HorseBreedingAttempt e = existing.get();
            e.setResult(result);
            e.setTimeStamp(System.currentTimeMillis());
            e.save();
        } else {
            HorseBreedingAttempt attempt = new HorseBreedingAttempt(initiatingHorse.getId(), targetedHorse.getId(), result, System.currentTimeMillis());
            this.horseBreedingAttemptRepository.add(attempt);
        }
    }

    @Override
    public Optional<Duration> getDurationSinceLastBreedingAttemptOnHorse(EQHorse initiatingHorse, EQHorse targetHorse) {
        return this.horseBreedingAttemptRepository.findByHorseAndOtherHorse(initiatingHorse.getId(), targetHorse.getId()).map(HorseBreedingAttempt::getTimeStamp).map(DateUtils::durationSince);
    }

    @Override
    public int getBreedingAttemptsInPastDuration(EQHorse horse, HorseBreedingAttemptResult result, Duration duration) {
        Date date = DateUtils.futureDurationOffset(duration.negated());
        return this.horseBreedingAttemptRepository.findCountForHorseSince(horse.getId(), result, date.getTime());
    }

    @Override
    public int getTotalBreedingAttemptsForHorse(EQHorse horse) {
        return this.horseBreedingAttemptRepository.findCountForHorse(horse.getId());
    }

    @Override
    public Optional<Duration> getDurationSinceHorseLastInvolvedInBreedingAttempt(EQHorse horse) {
        Optional<HorseBreedingAttempt> mostRecent = this.horseBreedingAttemptRepository.findByHorse(horse.getId());
        return mostRecent.map(HorseBreedingAttempt::getTimeStamp).map(DateUtils::durationSince);
    }
}

