/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.care;

import com.equestricraft.api.common.APIDurationDto;
import com.equestricraft.api.common.APIHorseCareDto;
import com.equestricraft.core.horse.care.HorseCareAccessor;
import java.time.Duration;

public class APIHorseCareDtoImpl
implements APIHorseCareDto {
    private final HorseCareAccessor horseCareAccessor;

    public APIHorseCareDtoImpl(HorseCareAccessor horseCareAccessor) {
        this.horseCareAccessor = horseCareAccessor;
    }

    @Override
    public APIDurationDto getDurationSinceLastClean() {
        Duration duration = this.horseCareAccessor.getDurationSinceLastClean();
        if (duration == null) {
            return null;
        }
        return new APIDurationDto(duration);
    }

    @Override
    public double getCleanPercentage() {
        return (double)this.getClean() * 100.0;
    }

    @Override
    public float getClean() {
        return this.horseCareAccessor.getCleanliness();
    }

    @Override
    public APIDurationDto getDurationSinceLastHoofClean() {
        Duration duration = this.horseCareAccessor.getDurationSinceLastHoofClean();
        if (duration == null) {
            return null;
        }
        return new APIDurationDto(duration);
    }

    @Override
    public double getHoofCleanPercentage() {
        return (double)this.getHoofClean() * 100.0;
    }

    @Override
    public float getHoofClean() {
        return this.horseCareAccessor.getHoofCleanliness();
    }

    @Override
    public boolean isDailyCareDone() {
        return this.horseCareAccessor.isDailyCareDone();
    }
}

