/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.care;

import com.equestricraft.cdi.Service;
import com.equestricraft.cdi.ServiceInstance;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseSettings;
import com.equestricraft.core.horse.care.DailyCareProvider;
import java.time.Duration;
import java.util.Date;

public class HorseCareAccessor
extends AbstractHorseAccessor {
    @Service
    private static ServiceInstance<DailyCareProvider> dailyCareProviders;

    public HorseCareAccessor(EQHorse horse) {
        super(horse);
    }

    public void brush() {
        this.horse.setLastBrush(new Date());
        this.horse.save();
    }

    public Duration getDurationSinceLastClean() {
        Date lastClean = this.horse.getLastBrush();
        if (lastClean == null) {
            return null;
        }
        return DateUtils.durationSince(lastClean);
    }

    public float getCleanliness() {
        Date lastBrush = this.horse.getLastBrush();
        if (lastBrush == null) {
            return 0.0f;
        }
        Duration durationSince = DateUtils.durationSince(lastBrush);
        long totalScaleSizeMillis = (long)HorseSettings.getCleanPercentageDurationHours().intValue() * 86400000L;
        return (float)((double)(totalScaleSizeMillis - durationSince.toMillis()) / (double)totalScaleSizeMillis);
    }

    public void cleanHooves() {
        this.horse.setLastHoofClean(new Date());
        this.horse.save();
    }

    public Duration getDurationSinceLastHoofClean() {
        Date lastHoofClean = this.horse.getLastHoofClean();
        if (lastHoofClean == null) {
            return null;
        }
        return DateUtils.durationSince(lastHoofClean);
    }

    public float getHoofCleanliness() {
        Date lastHoofClean = this.horse.getLastHoofClean();
        if (lastHoofClean == null) {
            return 0.0f;
        }
        Duration durationSince = DateUtils.durationSince(lastHoofClean);
        long totalScaleSizeMillis = (long)HorseSettings.getHoofCleanPercentageDurationHours().intValue() * 86400000L;
        return (float)((double)(totalScaleSizeMillis - durationSince.toMillis()) / (double)totalScaleSizeMillis);
    }

    public boolean isDailyCareDone() {
        return dailyCareProviders.stream().allMatch(p -> p.isComplete(this.horse));
    }
}

