/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.coat;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.HorseCoatMarking;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.coat.HorseCoatDetails;
import com.equestricraft.core.horse.coat.HorseCoatSession;
import java.util.ArrayList;

public class HorseCoatAccessor
extends AbstractHorseAccessor {
    @Service
    private static HorseCoatSession horseCoatSession;

    public HorseCoatAccessor(EQHorse horse) {
        super(horse);
    }

    public HorseCoatDetails getDetails() {
        return horseCoatSession.calculateCoat(this.horse);
    }

    public String getDescription() {
        HorseCoatDetails details = this.getDetails();
        String color = I18n.getLabel(details.getColor().getLabel());
        double gray = (double)details.getGrayScale() * 100.0;
        String patterns = this.buildPatternsString(details);
        return I18n.getLabel("horse.coat.description", color, gray, patterns);
    }

    private String buildPatternsString(HorseCoatDetails details) {
        ArrayList<String> patterns = new ArrayList<String>();
        for (HorseCoatMarking marking : details.getMarkings()) {
            patterns.add(I18n.getLabel(marking.getNameLabel()));
        }
        return String.join((CharSequence)", ", patterns);
    }

    public String toString() {
        return this.getDescription();
    }
}

