/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.coat;

import com.equestricraft.common.HorseCoatColor;
import com.equestricraft.common.HorseCoatMarking;
import com.equestricraft.common.util.NumberUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class HorseCoatDetails {
    private final HorseCoatColor color;
    private final float grayScale;
    private final List<HorseCoatMarking> markings;

    private HorseCoatDetails(HorseCoatColor color, float grayScale, List<HorseCoatMarking> markings) {
        this.color = color;
        this.grayScale = grayScale;
        this.markings = markings;
    }

    public HorseCoatColor getColor() {
        return this.color;
    }

    public float getGrayScale() {
        return this.grayScale;
    }

    public List<HorseCoatMarking> getMarkings() {
        return this.markings;
    }

    public static class Builder {
        private HorseCoatColor color;
        private float grayScale = 0.0f;
        private List<HorseCoatMarking> markings = new ArrayList<HorseCoatMarking>();

        private Builder() {
        }

        public Builder withColor(HorseCoatColor color) {
            Objects.requireNonNull(color, "Color cannot be null");
            this.color = color;
            return this;
        }

        public Builder withGrayScale(float grayScale) {
            this.grayScale = NumberUtils.keepWithinRange(Float.valueOf(grayScale), Float.valueOf(0.0f), Float.valueOf(1.0f)).floatValue();
            return this;
        }

        public Builder withMarkings(List<HorseCoatMarking> markings) {
            this.markings = markings;
            return this;
        }

        public Builder withMarking(HorseCoatMarking marking) {
            this.markings.add(marking);
            return this;
        }

        public HorseCoatDetails complete() {
            Objects.requireNonNull(this.color, "Must set a color");
            if (this.markings.contains((Object)HorseCoatMarking.NONE) && this.markings.size() > 1) {
                throw new IllegalArgumentException("Horse cannot have solid selected with other markings");
            }
            if (this.markings.isEmpty()) {
                this.markings = Collections.singletonList(HorseCoatMarking.NONE);
            }
            return new HorseCoatDetails(this.color, this.grayScale, this.markings);
        }

        public static Builder start() {
            return new Builder();
        }
    }
}

