/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.coat;

import com.equestricraft.common.BaseColor;
import com.equestricraft.common.CreamDilution;
import com.equestricraft.common.Dominance;
import com.equestricraft.common.HorseCoatColor;
import com.equestricraft.common.HorseCoatMarking;
import com.equestricraft.common.HorseCoatModifiers;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.core.allele.Allele;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.coat.HorseCoatDetails;
import com.equestricraft.core.horse.coat.HorseCoatSession;
import com.equestricraft.core.horse.genetic.HorseGeneticAccessor;

public class HorseCoatSessionImpl
implements HorseCoatSession {
    @Override
    public HorseCoatDetails calculateCoat(EQHorse horse) {
        HorseCoatDetails.Builder coatBuilder = HorseCoatDetails.Builder.start();
        HorseGeneticAccessor genetics = horse.getGenetics();
        this.setColor(coatBuilder, genetics);
        this.setGray(coatBuilder, genetics, horse);
        this.setMarkings(coatBuilder, genetics);
        return coatBuilder.complete();
    }

    private void setColor(HorseCoatDetails.Builder coatBuilder, HorseGeneticAccessor genetics) {
        ColorResult colorResult = this.determineColor(genetics);
        if (colorResult.baseColor() == BaseColor.BLACK) {
            if (colorResult.creamDilution() == CreamDilution.HALF) {
                coatBuilder.withColor(HorseCoatColor.SMOKEY_BLACK);
            } else if (colorResult.creamDilution() == CreamDilution.FULL) {
                coatBuilder.withColor(HorseCoatColor.SMOKEY_CREMELLO);
            } else if (colorResult.champagne()) {
                coatBuilder.withColor(HorseCoatColor.CHAMPAGNE);
            } else {
                coatBuilder.withColor(HorseCoatColor.BLACK);
            }
        } else if (colorResult.baseColor() == BaseColor.BAY) {
            if (colorResult.creamDilution() == CreamDilution.FULL) {
                coatBuilder.withColor(HorseCoatColor.PERLINO);
            } else if (colorResult.creamDilution() == CreamDilution.HALF) {
                coatBuilder.withColor(HorseCoatColor.BUCKSKIN);
            } else if (colorResult.roan()) {
                coatBuilder.withColor(HorseCoatColor.BAY_ROAN);
            } else if (colorResult.champagne()) {
                coatBuilder.withColor(HorseCoatColor.CHAMPAGNE_GOLD);
            } else {
                coatBuilder.withColor(HorseCoatColor.STANDARD_BAY);
            }
        } else if (colorResult.baseColor() == BaseColor.RED) {
            if (colorResult.creamDilution() == CreamDilution.FULL) {
                coatBuilder.withColor(HorseCoatColor.CREMELLO);
            } else if (colorResult.creamDilution() == CreamDilution.HALF) {
                if (colorResult.roan()) {
                    coatBuilder.withColor(HorseCoatColor.PALOMINO_ROAN);
                } else {
                    coatBuilder.withColor(HorseCoatColor.PALOMINO);
                }
            } else if (colorResult.roan()) {
                coatBuilder.withColor(HorseCoatColor.RED_ROAN);
            } else if (colorResult.champagne()) {
                coatBuilder.withColor(HorseCoatColor.CHAMPAGNE_AMBER);
            } else {
                coatBuilder.withColor(HorseCoatColor.CHESTNUT);
            }
        }
    }

    private ColorResult determineColor(HorseGeneticAccessor genetics) {
        Dominance extensionDominance = genetics.getAllele(Allele.EXTENSION).dominance();
        Dominance agoutiDominance = genetics.getAllele(Allele.AGOUTI).dominance();
        Dominance creamDominance = genetics.getAllele(Allele.CREAM).dominance();
        Dominance dunDominance = genetics.getAllele(Allele.DUN).dominance();
        Dominance silverDominance = genetics.getAllele(Allele.SILVER).dominance();
        Dominance champagneDominance = genetics.getAllele(Allele.CHAMPAGNE).dominance();
        Dominance roanDominance = genetics.getAllele(Allele.ROAN).dominance();
        BaseColor color = extensionDominance != Dominance.RECESSIVE ? (agoutiDominance != Dominance.RECESSIVE ? BaseColor.BAY : BaseColor.BLACK) : BaseColor.RED;
        CreamDilution dilution = creamDominance == Dominance.DOMINANT ? CreamDilution.FULL : (creamDominance == Dominance.HETEROZYGOUS ? CreamDilution.HALF : CreamDilution.NONE);
        boolean dun = dunDominance != Dominance.RECESSIVE;
        boolean silver = silverDominance != Dominance.RECESSIVE;
        boolean champagne = champagneDominance != Dominance.RECESSIVE;
        boolean roan = roanDominance != Dominance.RECESSIVE;
        return new ColorResult(color, dilution, dun, silver, champagne, roan);
    }

    private void setGray(HorseCoatDetails.Builder coatBuilder, HorseGeneticAccessor genetics, EQHorse horse) {
        Dominance grayDominance = genetics.getAllele(Allele.GRAY).dominance();
        if (grayDominance != Dominance.RECESSIVE) {
            int horseAgeMonths = horse.getAge().getMonths();
            float value = ((float)horseAgeMonths - horse.getGreyStartAgeMonths().getValue().floatValue()) / (horse.getGreyFinishAgeMonths().getValue().floatValue() - horse.getGreyStartAgeMonths().getValue().floatValue());
            coatBuilder.withGrayScale(NumberUtils.keepWithinRange(Float.valueOf(value), Float.valueOf(0.0f), Float.valueOf(1.0f)).floatValue());
        }
    }

    private void setMarkings(HorseCoatDetails.Builder coatBuilder, HorseGeneticAccessor genetics) {
        Dominance sabinoDominance = genetics.getAllele(Allele.SABINO).dominance();
        Dominance tobianoDominance = genetics.getAllele(Allele.TOBIANO).dominance();
        Dominance overoDominance = genetics.getAllele(Allele.OVERO).dominance();
        Dominance splashedWhiteDominance = genetics.getAllele(Allele.SPLASHED_WHITE).dominance();
        Dominance leopardDominance = genetics.getAllele(Allele.LEOPARD).dominance();
        Dominance patn1 = genetics.getAllele(Allele.PATN1).dominance();
        if (tobianoDominance != Dominance.RECESSIVE && splashedWhiteDominance != Dominance.RECESSIVE && sabinoDominance != Dominance.RECESSIVE) {
            coatBuilder.withMarking(HorseCoatMarking.BLAZE_1);
        }
        if (tobianoDominance != Dominance.RECESSIVE && overoDominance != Dominance.RECESSIVE) {
            coatBuilder.withMarking(HorseCoatMarking.TOVERO_1);
        }
        if (splashedWhiteDominance != Dominance.RECESSIVE && tobianoDominance != Dominance.RECESSIVE && overoDominance == Dominance.DOMINANT && sabinoDominance != Dominance.RECESSIVE) {
            coatBuilder.withMarking(HorseCoatMarking.BALD_FACE_1);
        }
        if (sabinoDominance != Dominance.RECESSIVE) {
            coatBuilder.withMarking(HorseCoatMarking.SABINO_1);
        }
        if (tobianoDominance != Dominance.RECESSIVE) {
            coatBuilder.withMarking(HorseCoatMarking.TOBIANO_1);
        }
        if (overoDominance == Dominance.HETEROZYGOUS) {
            coatBuilder.withMarking(HorseCoatMarking.OVERO_1);
        } else if (overoDominance == Dominance.DOMINANT) {
            coatBuilder.withMarking(HorseCoatMarking.FRAME_OVERO);
        }
        if (splashedWhiteDominance != Dominance.RECESSIVE) {
            coatBuilder.withMarking(HorseCoatMarking.SPLASH_1);
        }
        if (leopardDominance == Dominance.DOMINANT) {
            if (patn1 == Dominance.DOMINANT) {
                coatBuilder.withMarking(HorseCoatMarking.FEW_SPOT_APPALOOSA);
            } else {
                coatBuilder.withMarking(HorseCoatMarking.SNOWCAP_APPALOOSA_1);
            }
        } else if (leopardDominance == Dominance.HETEROZYGOUS) {
            if (patn1 == Dominance.RECESSIVE) {
                coatBuilder.withMarking(HorseCoatMarking.APPALOOSA_1);
            } else if (patn1 == Dominance.HETEROZYGOUS) {
                coatBuilder.withMarking(HorseCoatMarking.APPALOOSA_2);
            } else {
                coatBuilder.withMarking(HorseCoatMarking.APPALOOSA_3);
            }
        }
        if (tobianoDominance != Dominance.RECESSIVE || splashedWhiteDominance != Dominance.RECESSIVE || sabinoDominance != Dominance.RECESSIVE) {
            coatBuilder.withMarking(HorseCoatMarking.LEG_MARKINGS_1);
        }
    }

    @Override
    public HorseCoatDetails buildCoatDetails(HorseCoatColor colorSimple, HorseCoatModifiers modifiers) {
        HorseCoatDetails.Builder builder = HorseCoatDetails.Builder.start().withColor(colorSimple).withMarkings(modifiers.getMarkingSelections()).withGrayScale(modifiers.isGray() ? 1.0f : 0.0f);
        return builder.complete();
    }

    record ColorResult(BaseColor baseColor, CreamDilution creamDilution, boolean dun, boolean silver, boolean champagne, boolean roan) {
    }
}

