/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.command;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.command.AbstractHorseCommand;
import com.equestricraft.core.horse.name.HorseNameService;
import com.equestricraft.core.horse.name.HorseNameValidationException;
import com.equestricraft.core.horse.permission.HorsePermissionChecker;
import com.equestricraft.core.horse.permission.HorsePermissionLevel;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.logging.Log;

public class UpdateHorseNameCommand
extends AbstractHorseCommand {
    private final String name;
    @Service
    private static HorseNameService horseNameService;
    private static final Object horseNameLock;
    private static final Log log;

    public UpdateHorseNameCommand(ECPlayer player, String name) {
        super(player);
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response execute() {
        HorsePermissionChecker.ensureHasPermissionLevel(this.player, this.horse, HorsePermissionLevel.OWNER);
        try {
            Object object = horseNameLock;
            synchronized (object) {
                String newName = horseNameService.ensureValidForPlayer(this.horse.getOwner(), this.name);
                this.horse.setName(newName);
                this.horse.save();
                log.info("Updated name of horse {} to {}", (Object)this.horse.getId(), (Object)this.name);
                return ResponseFactory.success(I18n.getLabel("horse.name.updated.prompt.title"), I18n.getLabel("horse.name.updated.prompt.message", newName));
            }
        }
        catch (HorseNameValidationException ex) {
            return ResponseFactory.fail(I18n.getLabel("horse.name.not-updated.prompt.title"), ex);
        }
    }

    static {
        horseNameLock = new Object();
        log = Log.getLogger(UpdateHorseNameCommand.class.getName());
    }
}

