/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.command;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.common.HorseLogType;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.command.AbstractHorseCommand;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.logging.Log;

public class UpdateHorsesCurrentValue
extends AbstractHorseCommand {
    private final double value;
    private static final Log log = Log.getLogger(UpdateHorsesCurrentValue.class.getName());

    public UpdateHorsesCurrentValue(ECPlayer player, double value) {
        super(player);
        if (value < 0.0) {
            throw new IllegalArgumentException(I18n.getLabel("common.zero-or-greater"));
        }
        this.value = value;
    }

    @Override
    public Response execute() {
        this.horse.setCurrentValue(this.value);
        this.horse.save();
        log.info("Updated value of horse {} to {}", (Object)this.horse.getId(), (Object)this.value);
        this.horse.getLogs().log(this.player, HorseLogType.UPDATED, "Updated the current value for the horse to {0}", this.value);
        return ResponseFactory.success(I18n.getLabel("horse.current-value.updated.prompt.title"), I18n.getLabel("horse.current-value.updated.prompt.message", this.value));
    }
}

