/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.conformation;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.ConformationCheckType;
import com.equestricraft.common.util.PercentageUtils;
import com.equestricraft.core.conformation.check.BackConformationCheck;
import com.equestricraft.core.conformation.check.BarrelConformationCheck;
import com.equestricraft.core.conformation.check.ChestConformationCheck;
import com.equestricraft.core.conformation.check.ConformationCheck;
import com.equestricraft.core.conformation.check.ConformationCheckRating;
import com.equestricraft.core.conformation.check.ConformationCheckResult;
import com.equestricraft.core.conformation.check.FrontLegsConformationCheck;
import com.equestricraft.core.conformation.check.HeadConformationCheck;
import com.equestricraft.core.conformation.check.HindLegsConformationCheck;
import com.equestricraft.core.conformation.check.HindquartersConformationCheck;
import com.equestricraft.core.conformation.check.HoovesConformationCheck;
import com.equestricraft.core.conformation.check.NeckConformationCheck;
import com.equestricraft.core.conformation.check.ShouldersConformationCheck;
import com.equestricraft.core.conformation.measurement.ConformationMeasurement;
import com.equestricraft.core.conformation.measurement.ConformationMeasurementRepository;
import com.equestricraft.core.conformation.measurement.ConformationMeasurementType;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.conformation.HorseConformationMeasurement;
import com.equestricraft.core.horse.conformation.HorseConformationMeasurementRepository;
import java.util.Arrays;
import java.util.function.ToDoubleFunction;

public class HorseConformationAccessor
extends AbstractHorseAccessor {
    @Service
    private static HorseConformationMeasurementRepository horseConformationMeasurementRepository;
    @Service
    private static ConformationMeasurementRepository conformationMeasurementRepository;

    public HorseConformationAccessor(EQHorse horse) {
        super(horse);
    }

    public double getMeasurement(ConformationMeasurementType type) {
        ConformationMeasurement measurementType = conformationMeasurementRepository.findByType(type);
        HorseConformationMeasurement horsePart = horseConformationMeasurementRepository.findByHorseAndMeasurement(this.horse.getId(), measurementType.getId());
        if (horsePart == null) {
            return 50.0;
        }
        double delta = measurementType.getMaximumInitialValue() - measurementType.getMinimumInitialValue();
        double percentageForHorse = horsePart.getValue();
        double valueFromPercentage = PercentageUtils.of(delta, percentageForHorse);
        return measurementType.getMinimumInitialValue() + valueFromPercentage;
    }

    public double getCheckPercentage(ConformationCheckType type) {
        ConformationCheck check2 = this.getCheck(type);
        return check2.getConformationPercentage();
    }

    public ConformationCheckResult getCheckResult(ConformationCheckType type) {
        ConformationCheck check2 = this.getCheck(type);
        return check2.checkConformation();
    }

    public ConformationCheckRating getCheckRating(ConformationCheckType type) {
        ConformationCheck check2 = this.getCheck(type);
        return check2.getConformationRating();
    }

    public float getSpeedEffect() {
        return this.getAverageValueFromConformation(ConformationCheck::getSpeedEffectPercentage);
    }

    public float getJumpEffect() {
        return this.getAverageValueFromConformation(ConformationCheck::getJumpEffectPercentage);
    }

    public float getMaximumStaminaEffect() {
        return this.getAverageValueFromConformation(ConformationCheck::getStaminaEffectPercentage);
    }

    private float getAverageValueFromConformation(ToDoubleFunction<ConformationCheck> function) {
        return (float)Arrays.stream(ConformationCheckType.values()).map(this::getCheck).mapToDouble(function).average().orElse(100.0) / 100.0f;
    }

    private ConformationCheck getCheck(ConformationCheckType conformationCheckType) {
        return switch (conformationCheckType) {
            default -> throw new IncompatibleClassChangeError();
            case ConformationCheckType.BACK -> new BackConformationCheck(this.horse);
            case ConformationCheckType.BARREL -> new BarrelConformationCheck(this.horse);
            case ConformationCheckType.CHEST -> new ChestConformationCheck(this.horse);
            case ConformationCheckType.FRONT_LEGS -> new FrontLegsConformationCheck(this.horse);
            case ConformationCheckType.HEAD -> new HeadConformationCheck(this.horse);
            case ConformationCheckType.HIND_LEGS -> new HindLegsConformationCheck(this.horse);
            case ConformationCheckType.HINDQUARTERS -> new HindquartersConformationCheck(this.horse);
            case ConformationCheckType.NECK -> new NeckConformationCheck(this.horse);
            case ConformationCheckType.HOOVES -> new HoovesConformationCheck(this.horse);
            case ConformationCheckType.SHOULDERS -> new ShouldersConformationCheck(this.horse);
        };
    }
}

