/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.conformation;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.common.util.PercentageUtils;
import com.equestricraft.core.conformation.measurement.ConformationMeasurement;
import com.equestricraft.core.conformation.measurement.ConformationMeasurementRepository;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.conformation.HorseConformationInitialisationSession;
import com.equestricraft.core.horse.conformation.HorseConformationMeasurement;
import com.equestricraft.core.horse.conformation.HorseConformationMeasurementRepository;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class HorseConformationInitialisationSessionImpl
implements HorseConformationInitialisationSession {
    @Service
    private ConformationMeasurementRepository conformationMeasurementRepository;
    @Service
    private HorseConformationMeasurementRepository horseConformationMeasurementRepository;

    @Override
    public void initialiseConformationForHorse(EQHorse horse) {
        List<HorseConformationMeasurement> horseConformationPart = horse.hasParents() ? this.generateConformationFromParents(horse) : this.generateBlankConformation(horse);
        this.horseConformationMeasurementRepository.add(horseConformationPart);
    }

    private List<HorseConformationMeasurement> generateConformationFromParents(EQHorse horse) {
        List<HorseConformationMeasurement> motherConformation = this.horseConformationMeasurementRepository.findAllMeasurementsForHorse(horse.getMotherId());
        List<HorseConformationMeasurement> fatherConformation = this.horseConformationMeasurementRepository.findAllMeasurementsForHorse(horse.getFatherId());
        return this.conformationMeasurementRepository.streamAll().map(part -> {
            HorseConformationMeasurement motherValue = this.getPartMeasurement(motherConformation, (ConformationMeasurement)part);
            HorseConformationMeasurement fatherValue = this.getPartMeasurement(fatherConformation, (ConformationMeasurement)part);
            double childValue1 = this.getRandomAllele(motherValue);
            double childValue2 = this.getRandomAllele(fatherValue);
            childValue1 = this.applyRandomPercentageOffset((ConformationMeasurement)part, childValue1);
            childValue2 = this.applyRandomPercentageOffset((ConformationMeasurement)part, childValue2);
            double lowest = Math.min(childValue1, childValue2);
            double highest = Math.max(childValue1, childValue2);
            return new HorseConformationMeasurement(horse.getId(), part.getId(), lowest, highest);
        }).toList();
    }

    private double getRandomAllele(HorseConformationMeasurement horseConformationMeasurement) {
        if (ThreadLocalRandom.current().nextBoolean()) {
            return horseConformationMeasurement.getValue1();
        }
        return horseConformationMeasurement.getValue2();
    }

    private double applyRandomPercentageOffset(ConformationMeasurement part, double childValue) {
        double randomPercentage = NumberUtils.randomDoubleInRange(-part.getParentRandomOffsetPercentage(), part.getParentRandomOffsetPercentage());
        if (randomPercentage < 0.0) {
            return PercentageUtils.decreaseByPercentage(childValue, Math.abs(randomPercentage));
        }
        if (randomPercentage > 0.0) {
            return PercentageUtils.increaseByPercentage(childValue, randomPercentage);
        }
        return childValue;
    }

    private HorseConformationMeasurement getPartMeasurement(List<HorseConformationMeasurement> parts, ConformationMeasurement part) {
        return parts.stream().filter(p -> p.getMeasurementId() == part.getId()).findFirst().orElseThrow();
    }

    private List<HorseConformationMeasurement> generateBlankConformation(EQHorse horse) {
        return this.conformationMeasurementRepository.streamAll().map(part -> this.generatePartForHorse(horse, (ConformationMeasurement)part)).toList();
    }

    private HorseConformationMeasurement generatePartForHorse(EQHorse horse, ConformationMeasurement part) {
        double value1 = NumberUtils.randomDoubleInRange(0.0, 100.0);
        double value2 = NumberUtils.randomDoubleInRange(0.0, 100.0);
        double lowest = Math.min(value1, value2);
        double highest = Math.max(value1, value2);
        return new HorseConformationMeasurement(horse.getId(), part.getId(), lowest, highest);
    }
}

