/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.conformation;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.core.horse.conformation.HorseConformationMeasurementKey;
import java.util.Objects;

public class HorseConformationMeasurement
implements RepositoryEntity<HorseConformationMeasurementKey> {
    private final HorseConformationMeasurementKey key;
    private final double value1;
    private final double value2;

    public HorseConformationMeasurement(int horseId, int measurementId, double value1, double value2) {
        this.key = new HorseConformationMeasurementKey(horseId, measurementId);
        this.value1 = value1;
        this.value2 = value2;
    }

    @Override
    public HorseConformationMeasurementKey getKey() {
        return this.key;
    }

    public int getHorseId() {
        return this.getKey().horseId();
    }

    public int getMeasurementId() {
        return this.getKey().measurementId();
    }

    public double getValue() {
        return (this.value1 + this.value2) / 2.0;
    }

    public double getValue1() {
        return this.value1;
    }

    public double getValue2() {
        return this.value2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HorseConformationMeasurement that = (HorseConformationMeasurement)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }
}

