/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.conformation;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.horse.conformation.HorseConformationMeasurement;
import com.equestricraft.core.horse.conformation.HorseConformationMeasurementKey;
import java.util.List;

public class HorseConformationMeasurementDatabase
implements RepositoryDatasource<HorseConformationMeasurement, HorseConformationMeasurementKey> {
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_MEASUREMENT_ID = "MEASUREMENT_ID";
    private static final String COLUMN_MEASUREMENT_VALUE_1 = "MEASUREMENT_VALUE_1";
    private static final String COLUMN_MEASUREMENT_VALUE_2 = "MEASUREMENT_VALUE_2";

    @Override
    public void create(HorseConformationMeasurement horseConformationMeasurement) {
        Query.insertInto("HORSE_CONFORMATION_MEASUREMENT").columns(QueryColumn.column(COLUMN_HORSE_ID, horseConformationMeasurement.getHorseId()), QueryColumn.column(COLUMN_MEASUREMENT_ID, horseConformationMeasurement.getMeasurementId()), QueryColumn.column(COLUMN_MEASUREMENT_VALUE_1, horseConformationMeasurement.getValue1()), QueryColumn.column(COLUMN_MEASUREMENT_VALUE_2, horseConformationMeasurement.getValue2())).execute();
    }

    @Override
    public List<HorseConformationMeasurement> retrieveAll() {
        return Query.selectAllFrom("HORSE_CONFORMATION_MEASUREMENT").getList(this::getFromResultRow);
    }

    private HorseConformationMeasurement getFromResultRow(ResultRow row) {
        int horseId = row.getInt(COLUMN_HORSE_ID);
        int measurementId = row.getInt(COLUMN_MEASUREMENT_ID);
        double measurementValue1 = row.getDouble(COLUMN_MEASUREMENT_VALUE_1);
        double measurementValue2 = row.getDouble(COLUMN_MEASUREMENT_VALUE_2);
        return new HorseConformationMeasurement(horseId, measurementId, measurementValue1, measurementValue2);
    }
}

