/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.create;

import com.equestricraft.common.Dominance;
import com.equestricraft.common.HorseGender;
import com.equestricraft.common.HorseOrigin;
import com.equestricraft.core.allele.Allele;
import com.equestricraft.core.horse.coat.HorseCoatDetails;
import com.equestricraft.core.player.ECPlayer;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public final class HorseCreateRequest {
    private final String name;
    private final ECPlayer owner;
    private final HorseGender gender;
    private final int ageMonths;
    private final Integer motherId;
    private final Integer fatherId;
    private final Map<Allele, Dominance> alleleDominanceMap;
    private final Double currentValue;
    private final HorseOrigin origin;
    private final HorseCoatDetails coatDetails;
    private final boolean bypassHorseLimit;
    private final boolean allowDuplicateName;
    private final Double finalWeight;
    private final Double finalHeight;
    private final boolean forceImmortal;
    private final Integer trustLevel;
    private final boolean ownedByPlayer;
    private final Map<UUID, Double> tags;
    private final Float baseIntelligence;
    private final Float baseMemory;
    private final Integer baseMetabolismPercentage;
    private final Integer greyStartAgeMonths;
    private final Integer greyFinishAgeMonths;
    private final Double baseMaximumStamina;

    private HorseCreateRequest(String name, ECPlayer owner, HorseGender gender, int ageMonths, Integer motherId, Integer fatherId, Map<Allele, Dominance> alleleDominanceMap, Double currentValue, HorseOrigin origin, HorseCoatDetails coatDetails, boolean bypassHorseLimit, boolean allowDuplicateName, Double finalWeight, Double finalHeight, boolean forceImmortal, Integer trustLevel, boolean ownedByPlayer, Map<UUID, Double> tags, Float baseIntelligence, Float baseMemory, Integer baseMetabolismPercentage, Integer greyStartAgeMonths, Integer greyFinishAgeMonths, Double baseMaximumStamina) {
        this.name = name;
        this.owner = owner;
        this.gender = gender;
        this.ageMonths = ageMonths;
        this.motherId = motherId;
        this.fatherId = fatherId;
        this.alleleDominanceMap = alleleDominanceMap;
        this.currentValue = currentValue;
        this.origin = origin;
        this.coatDetails = coatDetails;
        this.bypassHorseLimit = bypassHorseLimit;
        this.allowDuplicateName = allowDuplicateName;
        this.finalWeight = finalWeight;
        this.finalHeight = finalHeight;
        this.forceImmortal = forceImmortal;
        this.trustLevel = trustLevel;
        this.ownedByPlayer = ownedByPlayer;
        this.tags = tags;
        this.baseIntelligence = baseIntelligence;
        this.baseMemory = baseMemory;
        this.baseMetabolismPercentage = baseMetabolismPercentage;
        this.greyStartAgeMonths = greyStartAgeMonths;
        this.greyFinishAgeMonths = greyFinishAgeMonths;
        this.baseMaximumStamina = baseMaximumStamina;
    }

    public String getName() {
        return this.name;
    }

    public ECPlayer getOwner() {
        return this.owner;
    }

    public HorseGender getGender() {
        return this.gender;
    }

    public int getAgeMonths() {
        return this.ageMonths;
    }

    public Integer getMotherId() {
        return this.motherId;
    }

    public Integer getFatherId() {
        return this.fatherId;
    }

    public Map<Allele, Dominance> getAlleleDominanceMap() {
        return this.alleleDominanceMap;
    }

    public Double getCurrentValue() {
        return this.currentValue;
    }

    public HorseOrigin getOrigin() {
        return this.origin;
    }

    public HorseCoatDetails getCoatDetails() {
        return this.coatDetails;
    }

    public boolean isBypassHorseLimit() {
        return this.bypassHorseLimit;
    }

    public boolean isAllowDuplicateName() {
        return this.allowDuplicateName;
    }

    public Double getFinalWeight() {
        return this.finalWeight;
    }

    public Double getFinalHeight() {
        return this.finalHeight;
    }

    public boolean isForceImmortal() {
        return this.forceImmortal;
    }

    public Integer getTrustLevel() {
        return this.trustLevel;
    }

    public boolean isOwnedByPlayer() {
        return this.ownedByPlayer;
    }

    public Map<UUID, Double> getTags() {
        return this.tags;
    }

    public Float getBaseIntelligence() {
        return this.baseIntelligence;
    }

    public Float getBaseMemory() {
        return this.baseMemory;
    }

    public Integer getBaseMetabolismPercentage() {
        return this.baseMetabolismPercentage;
    }

    public Integer getGreyStartAgeMonths() {
        return this.greyStartAgeMonths;
    }

    public Integer getGreyFinishAgeMonths() {
        return this.greyFinishAgeMonths;
    }

    public Double getBaseMaximumStamina() {
        return this.baseMaximumStamina;
    }

    public boolean hasParents() {
        return this.motherId != null && this.fatherId != null;
    }

    public static class Builder {
        private String name;
        private ECPlayer owner;
        private HorseGender gender;
        private Integer ageMonths;
        private Integer motherId;
        private Integer fatherId;
        private Map<Allele, Dominance> alleleDominanceMap = new EnumMap<Allele, Dominance>(Allele.class);
        private Double currentValue;
        private HorseOrigin origin;
        private HorseCoatDetails coatDetails;
        private boolean bypassHorseLimit = false;
        private boolean allowDuplicateName = false;
        private Double finalWeight = null;
        private Double finalHeight = null;
        private boolean forceImmortal = false;
        private Integer trustLevel = null;
        private boolean ownedByPlayer = true;
        private Map<UUID, Double> tags = new HashMap<UUID, Double>();
        private Float baseIntelligence = null;
        private Float baseMemory = null;
        private Integer baseMetabolismPercentage = null;
        private Integer greyStartAgeMonths = null;
        private Integer greyFinishAgeMonths = null;
        private Double baseMaximumStamina = null;

        private Builder() {
        }

        public Builder withName(String name) {
            this.name = name.trim();
            return this;
        }

        public Builder withOwner(ECPlayer owner) {
            this.owner = owner;
            return this;
        }

        public Builder withGender(HorseGender gender) {
            this.gender = gender;
            return this;
        }

        public Builder withAgeMonths(int ageMonths) {
            this.ageMonths = ageMonths;
            return this;
        }

        public Builder withParents(int motherId, int fatherId) {
            this.motherId = motherId;
            this.fatherId = fatherId;
            return this;
        }

        public Builder withCurrentValue(double currentValue) {
            this.currentValue = currentValue;
            return this;
        }

        public Builder withAllele(Allele allele, Dominance dominance) {
            this.alleleDominanceMap.put(allele, dominance);
            return this;
        }

        public Builder withAlleles(Map<Allele, Dominance> alleleDominanceMap) {
            this.alleleDominanceMap = new EnumMap<Allele, Dominance>(alleleDominanceMap);
            return this;
        }

        public Builder withOrigin(HorseOrigin origin) {
            this.origin = origin;
            return this;
        }

        public Builder withCoatDetails(HorseCoatDetails coatDetails) {
            this.coatDetails = coatDetails;
            return this;
        }

        public Builder withBypassHorseLimit(boolean bypassHorseLimit) {
            this.bypassHorseLimit = bypassHorseLimit;
            return this;
        }

        public Builder withAllowDuplicateName(boolean allowDuplicateName) {
            this.allowDuplicateName = allowDuplicateName;
            return this;
        }

        public Builder withFinalWeight(Double finalWeight) {
            this.finalWeight = finalWeight;
            return this;
        }

        public Builder withFinalHeight(Double finalHeight) {
            this.finalHeight = finalHeight;
            return this;
        }

        public Builder withForceImmortal(boolean forceImmortal) {
            this.forceImmortal = forceImmortal;
            return this;
        }

        public Builder withTrustLevel(Integer trustLevel) {
            this.trustLevel = trustLevel;
            return this;
        }

        public Builder withOwnedByPlayer(boolean ownedByPlayer) {
            this.ownedByPlayer = ownedByPlayer;
            return this;
        }

        public Builder withTag(UUID id, Double value) {
            this.tags.put(id, value);
            return this;
        }

        public Builder withTags(Map<UUID, Double> tags) {
            this.tags = new HashMap<UUID, Double>(tags);
            return this;
        }

        public Builder withBaseIntelligence(Float baseIntelligence) {
            this.baseIntelligence = baseIntelligence;
            return this;
        }

        public Builder withBaseMemory(Float baseMemory) {
            this.baseMemory = baseMemory;
            return this;
        }

        public Builder withBaseMetabolismPercentage(Integer baseMetabolismPercentage) {
            this.baseMetabolismPercentage = baseMetabolismPercentage;
            return this;
        }

        public Builder withGreyStartAgeMonths(Integer greyStartAgeMonths, Integer greyFinishAgeMonths) {
            this.greyStartAgeMonths = greyStartAgeMonths;
            this.greyFinishAgeMonths = greyFinishAgeMonths;
            return this;
        }

        public Builder withBaseMaximumStamina(Double baseMaximumStamina) {
            this.baseMaximumStamina = baseMaximumStamina;
            return this;
        }

        public HorseCreateRequest complete() {
            this.validate();
            return new HorseCreateRequest(this.name, this.owner, this.gender, this.ageMonths, this.motherId, this.fatherId, this.alleleDominanceMap, this.currentValue, this.origin, this.coatDetails, this.bypassHorseLimit, this.allowDuplicateName, this.finalWeight, this.finalHeight, this.forceImmortal, this.trustLevel, this.ownedByPlayer, this.tags, this.baseIntelligence, this.baseMemory, this.baseMetabolismPercentage, this.greyStartAgeMonths, this.greyFinishAgeMonths, this.baseMaximumStamina);
        }

        private void validate() {
            ArrayList<String> messages = new ArrayList<String>(0);
            if (this.name == null || this.name.isBlank()) {
                messages.add("Must provide a name for the horse");
            }
            if (this.owner == null) {
                messages.add("Horse must have an owner");
            }
            if (this.gender == null) {
                messages.add("Horse must have a gender");
            }
            if (this.ageMonths == null) {
                messages.add("Horse must have an age");
            }
            if (this.origin == null) {
                messages.add("Horse must have an origin");
            }
            if (this.coatDetails == null && this.alleleDominanceMap == null) {
                messages.add("Must provider with coat details or alleles");
            }
            if (this.coatDetails != null && !this.alleleDominanceMap.isEmpty()) {
                messages.add("Must not provide both coat details and alleles");
            }
            if (!messages.isEmpty()) {
                throw new IllegalArgumentException(String.join((CharSequence)", ", messages));
            }
        }

        public static Builder start() {
            return new Builder();
        }
    }
}

