/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.create;

import com.equestricraft.base.database.TransactionManagement;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.BreedCoatPolicy;
import com.equestricraft.common.HorseCoatColor;
import com.equestricraft.common.HorseCoatMarking;
import com.equestricraft.common.HorseGaitVariant;
import com.equestricraft.common.HorseLogType;
import com.equestricraft.common.genetic.NumericalGeneticValue;
import com.equestricraft.common.height.HorseHeight;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.ListUtils;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.core.blood.BloodType;
import com.equestricraft.core.blood.BloodTypeRepository;
import com.equestricraft.core.breed.Breed;
import com.equestricraft.core.breed.BreedColor;
import com.equestricraft.core.breed.BreedInfo;
import com.equestricraft.core.breed.BreedMarking;
import com.equestricraft.core.breed.BreedMarkingGroup;
import com.equestricraft.core.breed.BreedRepository;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.HorseSettings;
import com.equestricraft.core.horse.age.HorseAgeSession;
import com.equestricraft.core.horse.blood.HorseBloodSession;
import com.equestricraft.core.horse.breed.HorseBreedSession;
import com.equestricraft.core.horse.conformation.HorseConformationInitialisationSession;
import com.equestricraft.core.horse.create.HorseCreateBreedRequest;
import com.equestricraft.core.horse.create.HorseCreateException;
import com.equestricraft.core.horse.create.HorseCreateRequest;
import com.equestricraft.core.horse.create.HorseCreateSession;
import com.equestricraft.core.horse.create.ValidHorseCreateSelections;
import com.equestricraft.core.horse.genetic.HorseGeneticSession;
import com.equestricraft.core.horse.height.HorseHeightSettings;
import com.equestricraft.core.horse.name.HorseNameService;
import com.equestricraft.core.horse.name.HorseNameValidationException;
import com.equestricraft.core.horse.nutrient.HorseNutritionUpdateSession;
import com.equestricraft.core.horse.pregnancy.PregnancySession;
import com.equestricraft.core.horse.provision.HorseProvisionGiveSession;
import com.equestricraft.core.horse.trust.HorsePlayerTrustSession;
import com.equestricraft.core.horse.weight.HorseWeightSettings;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.rank.Rank;
import com.equestricraft.logging.Log;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@TransactionManagement
public class HorseCreateSessionImpl
implements HorseCreateSession {
    @Service
    private HorseRepository horseRepository;
    @Service
    private HorseGeneticSession horseGeneticSession;
    @Service
    private HorseNameService horseNameService;
    @Service
    private HorseBloodSession horseBloodSession;
    @Service
    private HorseNutritionUpdateSession horseNutritionUpdateSession;
    @Service
    private HorsePlayerTrustSession horsePlayerTrustSession;
    @Service
    private HorseAgeSession horseAgeSession;
    @Service
    private BloodTypeRepository bloodTypeRepository;
    @Service
    private HorseConformationInitialisationSession horseConformationInitialisationSession;
    @Service
    private HorseProvisionGiveSession horseProvisionGiveSession;
    @Service
    private PregnancySession pregnancySession;
    @Service
    private HorseBreedSession horseBreedSession;
    @Service
    private BreedRepository breedRepository;
    private static final Log log = Log.getLogger(HorseCreateSessionImpl.class.getName());

    @Override
    public EQHorse createHorse(HorseCreateRequest horseCreateRequest) throws HorseCreateException {
        BloodType bloodType;
        ECPlayer owner = horseCreateRequest.getOwner();
        if (!horseCreateRequest.isBypassHorseLimit()) {
            this.ensurePlayerNotAtHorseLimit(owner);
        }
        String name = this.getValidName(horseCreateRequest, owner);
        Date birthTime = this.getValidBirthDate(horseCreateRequest);
        EQHorse horse = new EQHorse();
        horse.setName(name);
        horse.setOwnerId(owner.getId());
        horse.setHorseGender(horseCreateRequest.getGender());
        horse.setBreedClassified(false);
        horse.setBirthTime(birthTime);
        horse.setLastNutritionReduction(new Date());
        if (horseCreateRequest.getCurrentValue() != null) {
            horse.setCurrentValue(horseCreateRequest.getCurrentValue());
        }
        horse.setOrigin(horseCreateRequest.getOrigin());
        horse.setShowMoreLineageInformation(false);
        horse.setLastHoofTrim(System.currentTimeMillis());
        horse.setHorseShoe(null);
        horse.setBitId(null);
        horse.setBitTime(null);
        horse.setBitEndTime(null);
        horse.setCreatedTime(new Date());
        horse.setHoofWearPercentage(0.0);
        if (horseCreateRequest.hasParents()) {
            horse.setMotherId(horseCreateRequest.getMotherId());
            horse.setFatherId(horseCreateRequest.getFatherId());
            EQHorse mother = (EQHorse)this.horseRepository.findByKey(horseCreateRequest.getMotherId());
            EQHorse father = (EQHorse)this.horseRepository.findByKey(horseCreateRequest.getFatherId());
            Integer n = ListUtils.getRandom(mother.getBloodTypeId(), father.getBloodTypeId());
            horse.setBloodTypeId(Objects.requireNonNull(n));
            horse.setBaseIntelligence(new NumericalGeneticValue(mother.getBaseIntelligence(), father.getBaseIntelligence()));
            horse.setBaseMemory(new NumericalGeneticValue(mother.getBaseMemory(), father.getBaseMemory()));
            horse.setBaseMetabolismPercentage(new NumericalGeneticValue(mother.getBaseMetabolismPercentage(), father.getBaseMetabolismPercentage()));
            horse.setBaseWeight(new NumericalGeneticValue(mother.getBaseWeight(), father.getBaseWeight()));
            horse.setBaseHeight(new NumericalGeneticValue(mother.getBaseHeight(), father.getBaseHeight()));
            horse.setGreyStartAgeMonths(new NumericalGeneticValue(mother.getGreyStartAgeMonths(), father.getGreyStartAgeMonths()));
            horse.setGreyFinishAgeMonths(new NumericalGeneticValue(mother.getGreyFinishAgeMonths(), father.getGreyFinishAgeMonths()));
            horse.setBaseMaximumStamina(new NumericalGeneticValue(mother.getBaseMaximumStamina(), father.getBaseMaximumStamina()));
        } else {
            bloodType = (BloodType)ListUtils.getRandomItem(this.bloodTypeRepository.findAll());
            horse.setBloodTypeId(bloodType.getId());
            if (horseCreateRequest.getBaseIntelligence() != null) {
                horse.setBaseIntelligence(NumericalGeneticValue.create(horseCreateRequest.getBaseIntelligence().floatValue()));
            } else {
                horse.setBaseIntelligence(new NumericalGeneticValue(Float.valueOf(NumberUtils.randomFloatInRange(0.4f, 0.9f)), Float.valueOf(NumberUtils.randomFloatInRange(0.4f, 0.9f))));
            }
            if (horseCreateRequest.getBaseMemory() != null) {
                horse.setBaseMemory(NumericalGeneticValue.create(horseCreateRequest.getBaseMemory().floatValue()));
            } else {
                horse.setBaseMemory(new NumericalGeneticValue(Float.valueOf(NumberUtils.randomFloatInRange(0.4f, 0.9f)), Float.valueOf(NumberUtils.randomFloatInRange(0.4f, 0.9f))));
            }
            if (horseCreateRequest.getBaseMetabolismPercentage() != null) {
                horse.setBaseMetabolismPercentage(NumericalGeneticValue.create(horseCreateRequest.getBaseMetabolismPercentage()));
            } else {
                horse.setBaseMetabolismPercentage(new NumericalGeneticValue(90, 110));
            }
            if (horseCreateRequest.getFinalWeight() != null) {
                horse.setBaseWeight(this.buildGeneticValue(horseCreateRequest.getFinalWeight()));
            } else {
                horse.setBaseWeight(new NumericalGeneticValue(HorseWeightSettings.getFinalWeightLower(), HorseWeightSettings.getFinalWeightUpper()));
            }
            if (horseCreateRequest.getFinalHeight() != null) {
                horse.setBaseHeight(this.buildGeneticValue(horseCreateRequest.getFinalHeight()));
            } else {
                horse.setBaseHeight(new NumericalGeneticValue(HorseHeightSettings.getFinalHeightLower(), HorseHeightSettings.getFinalHeightUpper()));
            }
            if (horseCreateRequest.getGreyStartAgeMonths() != null && horseCreateRequest.getGreyFinishAgeMonths() != null) {
                horse.setGreyStartAgeMonths(NumericalGeneticValue.create(horseCreateRequest.getGreyStartAgeMonths()));
                horse.setGreyFinishAgeMonths(NumericalGeneticValue.create(horseCreateRequest.getGreyFinishAgeMonths()));
            } else {
                horse.setGreyStartAgeMonths(new NumericalGeneticValue(this.calculateRandomStartAge(), this.calculateRandomStartAge()));
                horse.setGreyFinishAgeMonths(new NumericalGeneticValue(this.calculateRandomFinishAge(), this.calculateRandomFinishAge()));
            }
            if (horseCreateRequest.getBaseMaximumStamina() != null) {
                horse.setBaseMaximumStamina(NumericalGeneticValue.create(horseCreateRequest.getBaseMaximumStamina()));
            } else {
                horse.setBaseMaximumStamina(NumericalGeneticValue.create(10000));
            }
        }
        horse.setImmortal(horseCreateRequest.isForceImmortal() || owner.getHorses().getLiving().isEmpty());
        horse.setGaitVariant(HorseGaitVariant.STANDARD);
        horse = this.horseRepository.add(horse);
        this.initHorsesGenetics(horseCreateRequest, horse);
        bloodType = this.horseBloodSession.determineBloodTypeForHorse(horse);
        horse.setBloodTypeId(bloodType.getId());
        this.horseNutritionUpdateSession.initialiseHorsesNutrients(horse.getId());
        if (horseCreateRequest.getTrustLevel() != null) {
            this.horsePlayerTrustSession.initialisePlayerTrustWithHorse(owner, horse, horseCreateRequest.getTrustLevel());
        } else {
            this.horsePlayerTrustSession.initialisePlayerTrustWithHorse(horse.getOwner(), horse);
        }
        horse.setOwnedByPlayer(horseCreateRequest.isOwnedByPlayer());
        this.horseConformationInitialisationSession.initialiseConformationForHorse(horse);
        this.horseProvisionGiveSession.initialiseProvisionForHorse(horse);
        for (Map.Entry entry : horseCreateRequest.getTags().entrySet()) {
            horse.getTags().setValueForTag((UUID)entry.getKey(), (double)((Double)entry.getValue()));
        }
        HorseGaitVariant gaitVariant = this.determineGaitVariant(horse);
        horse.setGaitVariant(gaitVariant);
        horse.save();
        horse.getLogs().log(owner, HorseLogType.CREATED, "Horse has been created", new Object[0]);
        log.info("Created new horse {} for player {}", (Object)horse.getId(), (Object)owner.getId());
        return horse;
    }

    @Override
    public List<BreedInfo> getValidBreeds(HorseCreateBreedRequest horseCreateBreedRequest) {
        List<Breed> breeds = this.horseBreedSession.retrieveValidBreeds(horseCreateBreedRequest);
        return breeds.stream().filter(Breed::isAvailableForCustomHorses).map(this::buildInfo).toList();
    }

    @Override
    public List<BreedInfo> getAllCreateBreeds() {
        List<Breed> breeds = this.breedRepository.findForCustomHorses();
        return breeds.stream().map(this::buildInfo).toList();
    }

    private BreedInfo buildInfo(Breed breed) {
        return new BreedInfo(breed.getId(), breed.getName(), breed.getDescription());
    }

    @Override
    public ValidHorseCreateSelections getValidHorseCreateSelections(Breed breed) {
        double minimumHeight = HorseHeight.ofMeters(breed.getMinimumHeight()).getHands();
        double maximumHeight = HorseHeight.ofMeters(breed.getMaximumHeight()).getHands();
        Optional<HorseCoatColor> requiredColor = breed.getColors().stream().filter(c -> c.getPolicy() == BreedCoatPolicy.REQUIRED).map(BreedColor::getColor).findFirst();
        List colors = requiredColor.map(Collections::singletonList).orElseGet(() -> breed.getColors().stream().filter(c -> c.getPolicy() == BreedCoatPolicy.OPTIONAL).map(BreedColor::getColor).toList());
        List<HorseCoatMarking> requiredMarkings = breed.getMarkings().stream().filter(m -> m.getPolicy() == BreedCoatPolicy.REQUIRED).map(BreedMarking::getMarking).toList();
        List<HorseCoatMarking> optionalMarkings = breed.getMarkings().stream().filter(m -> m.getPolicy() == BreedCoatPolicy.OPTIONAL).map(BreedMarking::getMarking).toList();
        List<HorseCoatMarking.MarkingGroup> requiredMarkingGroups = breed.getMarkingGroups().stream().filter(m -> m.getPolicy() == BreedCoatPolicy.REQUIRED).map(BreedMarkingGroup::getGroup).toList();
        List<HorseCoatMarking.MarkingGroup> optionalMarkingGroups = breed.getMarkingGroups().stream().filter(m -> m.getPolicy() == BreedCoatPolicy.OPTIONAL).map(BreedMarkingGroup::getGroup).toList();
        return new ValidHorseCreateSelections(minimumHeight, maximumHeight, colors, requiredMarkings, optionalMarkings, requiredMarkingGroups, optionalMarkingGroups, breed.getStallionMinimumWeight(), breed.getStallionMaximumWeight(), breed.getMareMinimumWeight(), breed.getMareMaximumWeight());
    }

    private NumericalGeneticValue buildGeneticValue(double value) {
        double lower = value * 0.9;
        double upper = value * 1.1;
        return new NumericalGeneticValue(lower, upper);
    }

    private void ensurePlayerNotAtHorseLimit(ECPlayer owner) throws HorseCreateException {
        int unbornFoalHorseCount;
        if (owner.getPermission().hasPermission("equestricraft.horse.bypass-rank-limit")) {
            return;
        }
        Rank ownerRank = owner.getProgression().getRank();
        int livingHorseCount = owner.getHorses().getLiving().size();
        int totalHorseCount = livingHorseCount + (unbornFoalHorseCount = this.pregnancySession.getUnbornFoalCountForPlayer(owner));
        if (totalHorseCount >= ownerRank.getMaxHorses()) {
            throw new HorseCreateException(I18n.getLabel("horse.create.at-rank-limit"));
        }
    }

    private String getValidName(HorseCreateRequest horseCreateRequest, ECPlayer owner) throws HorseCreateException {
        try {
            return this.horseNameService.ensureValidForPlayer(owner, horseCreateRequest.getName(), !horseCreateRequest.isAllowDuplicateName());
        }
        catch (HorseNameValidationException ex) {
            throw new HorseCreateException(ex.getMessage());
        }
    }

    private Date getValidBirthDate(HorseCreateRequest horseCreateRequest) throws HorseCreateException {
        int maximumAgeMonths;
        int ageMonths = horseCreateRequest.getAgeMonths();
        if (ageMonths >= (maximumAgeMonths = HorseSettings.getCreateMaximumAgeMonths().intValue())) {
            String displayString = this.horseAgeSession.formatAgeInMonths(maximumAgeMonths);
            throw new HorseCreateException(I18n.getLabel("horse.create.too-old", displayString));
        }
        return this.horseAgeSession.determineBirthTimeFromAgeInMonths(ageMonths);
    }

    private void initHorsesGenetics(HorseCreateRequest horseCreateRequest, EQHorse horse) {
        if (horseCreateRequest.getAlleleDominanceMap().isEmpty()) {
            if (horseCreateRequest.getCoatDetails() != null) {
                this.horseGeneticSession.initGeneticsFromCoat(horse, horseCreateRequest.getCoatDetails());
            } else {
                this.horseGeneticSession.initGeneticsFromParents(horse);
            }
        } else {
            this.horseGeneticSession.setGeneticsForHorse(horse, horseCreateRequest.getAlleleDominanceMap());
        }
    }

    private int calculateRandomStartAge() {
        int lower = HorseSettings.getHorseGreyStartMonthsLowest();
        int higher = HorseSettings.getHorseGreyStartMonthsHighest();
        return NumberUtils.randomIntInRange(lower, higher);
    }

    private int calculateRandomFinishAge() {
        int lower = HorseSettings.getHorseGreyFinishMonthsLowest();
        int higher = HorseSettings.getHorseGreyFinishMonthsHighest();
        return NumberUtils.randomIntInRange(lower, higher);
    }

    private HorseGaitVariant determineGaitVariant(EQHorse horse) {
        return HorseGaitVariant.STANDARD;
    }
}

