/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.death;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseSession;
import com.equestricraft.core.horse.death.HorseDeadException;
import java.time.Duration;
import java.util.Date;

public class HorseDeathAccessor
extends AbstractHorseAccessor {
    @Service
    private static HorseSession horseSession;

    public HorseDeathAccessor(EQHorse horse) {
        super(horse);
    }

    public boolean isDead() {
        return this.horse.isDead();
    }

    public Date getTime() {
        return this.horse.getDeathTime();
    }

    public Duration getDurationSince() {
        Date time = this.getTime();
        if (time == null) {
            return null;
        }
        return DateUtils.durationSince(time);
    }

    public String getReason() {
        return this.horse.getDeathReason();
    }

    public void kill(String reason) throws HorseDeadException {
        horseSession.killHorse(this.horse, reason);
    }

    public void revive() {
        horseSession.reviveHorse(this.horse);
    }
}

