/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.discipline;

import com.equestricraft.api.common.APIDisciplineDto;
import com.equestricraft.api.common.APIHorseCertifiedDisciplinesDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.MapAdapter;
import com.equestricraft.core.discipline.APIDisciplineDtoImpl;
import com.equestricraft.core.discipline.Discipline;
import com.equestricraft.core.discipline.DisciplineTransformer;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

public class APIHorseCertifiedDisciplinesDtoImpl
extends MapAdapter<String, APIDisciplineDto>
implements APIHorseCertifiedDisciplinesDto {
    private final List<Discipline> disciplines;
    @Service
    private static DisciplineTransformer disciplineTransformer;

    public APIHorseCertifiedDisciplinesDtoImpl(List<Discipline> disciplines) {
        this.disciplines = disciplines;
    }

    @Override
    public int size() {
        return this.disciplines.size();
    }

    @Override
    public APIDisciplineDto get(Object key) {
        Optional<Discipline> discipline = this.findByKey(key);
        return discipline.map(disciplineTransformer::toDto).orElse(null);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.findByKey(key).isPresent();
    }

    private Optional<Discipline> findByKey(Object key) {
        Predicate<Discipline> predicate;
        if (key instanceof String) {
            String identifier = (String)key;
            predicate = d -> d.getIdentifier().equals(identifier);
        } else if (key instanceof Integer) {
            Integer id = (Integer)key;
            predicate = d -> d.getId() == id.intValue();
        } else {
            if (key instanceof APIDisciplineDtoImpl) {
                APIDisciplineDtoImpl disciplineDto = (APIDisciplineDtoImpl)key;
                return Optional.of(disciplineDto.getDiscipline());
            }
            throw new IllegalArgumentException("Invalid key provided");
        }
        return this.disciplines.stream().filter(predicate).findFirst();
    }

    @Override
    public Set<Map.Entry<String, APIDisciplineDto>> entrySet() {
        return new EntrySet();
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<String, APIDisciplineDto>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, APIDisciplineDto>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return APIHorseCertifiedDisciplinesDtoImpl.this.disciplines.size();
        }

        final class EntrySetIterator
        implements Iterator<Map.Entry<String, APIDisciplineDto>> {
            private final Iterator<Discipline> iterator;

            EntrySetIterator() {
                this.iterator = APIHorseCertifiedDisciplinesDtoImpl.this.disciplines.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Map.Entry<String, APIDisciplineDto> next() {
                Discipline next = this.iterator.next();
                APIDisciplineDto dto = disciplineTransformer.toDto(next);
                return Map.entry(next.getIdentifier(), dto);
            }
        }
    }
}

