/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.discipline;

import com.equestricraft.api.common.APIDisciplineDto;
import com.equestricraft.api.common.APIDurationDto;
import com.equestricraft.api.common.APIHorseCertifiedDisciplinesDto;
import com.equestricraft.api.common.APIHorseDisciplinesDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.discipline.Discipline;
import com.equestricraft.core.discipline.DisciplineTransformer;
import com.equestricraft.core.horse.discipline.APIHorseCertifiedDisciplinesDtoImpl;
import com.equestricraft.core.horse.discipline.HorseDisciplineAccessor;
import java.util.AbstractList;
import java.util.Date;
import java.util.List;

public class APIHorseDisciplinesDtoImpl
extends AbstractList<APIDisciplineDto>
implements APIHorseDisciplinesDto {
    private final HorseDisciplineAccessor horseDisciplineAccessor;
    private List<Discipline> certified = null;
    @Service
    private static DisciplineTransformer disciplineTransformer;

    public APIHorseDisciplinesDtoImpl(HorseDisciplineAccessor horseDisciplineAccessor) {
        this.horseDisciplineAccessor = horseDisciplineAccessor;
    }

    @Override
    public List<APIDisciplineDto> certify() {
        List<Discipline> disciplines = this.horseDisciplineAccessor.certify();
        return disciplineTransformer.toDtoList(disciplines);
    }

    @Override
    public Date getCertifiedDate() {
        return this.horseDisciplineAccessor.getLastCertifiedDate().orElse(null);
    }

    @Override
    public APIDurationDto getDurationSinceCertified() {
        return this.horseDisciplineAccessor.getDurationSinceCertified().map(APIDurationDto::new).orElse(null);
    }

    @Override
    public APIHorseCertifiedDisciplinesDto getCertified() {
        this.ensureCertifiedLoaded();
        return new APIHorseCertifiedDisciplinesDtoImpl(this.certified);
    }

    @Override
    public APIDisciplineDto get(int index) {
        this.ensureCertifiedLoaded();
        Discipline discipline = this.certified.get(index);
        return disciplineTransformer.toDto(discipline);
    }

    @Override
    public int size() {
        this.ensureCertifiedLoaded();
        if (this.certified == null) {
            this.certified = this.horseDisciplineAccessor.getCertified();
        }
        return this.certified.size();
    }

    private void ensureCertifiedLoaded() {
        if (this.certified == null) {
            this.certified = this.horseDisciplineAccessor.getCertified();
        }
    }
}

