/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.discipline;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.discipline.Discipline;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.discipline.HorseDisciplineSession;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class HorseDisciplineAccessor
extends AbstractHorseAccessor {
    @Service
    private static HorseDisciplineSession horseDisciplineSession;

    public HorseDisciplineAccessor(EQHorse horse) {
        super(horse);
    }

    public List<Discipline> certify() {
        return horseDisciplineSession.certifyHorsesDisciplines(this.horse);
    }

    public Optional<Date> getLastCertifiedDate() {
        return Optional.ofNullable(this.horse.getLastDisciplineCertification());
    }

    public Optional<Duration> getDurationSinceCertified() {
        Optional<Date> date = this.getLastCertifiedDate();
        return date.map(DateUtils::durationSince);
    }

    public List<Discipline> getCertified() {
        return horseDisciplineSession.getHorsesCertifiedDisciplines(this.horse);
    }

    public boolean isCertified(Discipline discipline) {
        return horseDisciplineSession.doesHorseHaveDisciplineCertified(this.horse, discipline);
    }
}

