/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.discipline;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.horse.discipline.HorseDiscipline;
import com.equestricraft.core.horse.discipline.HorseDisciplineKey;
import java.util.List;

public class HorseDisciplineDatabase
implements RepositoryDatasource<HorseDiscipline, HorseDisciplineKey> {
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_DISCIPLINE_ID = "DISCIPLINE_ID";

    @Override
    public void create(HorseDiscipline horseDiscipline) {
        Query.insertInto("DISCIPLINE_HORSE").columns(QueryColumn.column(COLUMN_HORSE_ID, horseDiscipline.getHorseId()), QueryColumn.column(COLUMN_DISCIPLINE_ID, horseDiscipline.getDisciplineId())).execute();
    }

    @Override
    public List<HorseDiscipline> retrieveAll() {
        return Query.selectAllFrom("DISCIPLINE_HORSE").getList(this::getFromResultRow);
    }

    private HorseDiscipline getFromResultRow(ResultRow row) {
        int horseId = row.getInt(COLUMN_HORSE_ID);
        int disciplineId = row.getInt(COLUMN_DISCIPLINE_ID);
        return new HorseDiscipline(horseId, disciplineId);
    }

    public void clearHorsesDisciplines(int horseId) {
        Query.deleteFrom("DISCIPLINE_HORSE").where(QueryColumn.column(COLUMN_HORSE_ID, horseId)).execute();
    }
}

