/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.discipline;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.discipline.Discipline;
import com.equestricraft.core.discipline.DisciplineRepository;
import com.equestricraft.core.horse.APIHorseDtoImpl;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.discipline.HorseDiscipline;
import com.equestricraft.core.horse.discipline.HorseDisciplineAdapter;
import com.equestricraft.core.horse.discipline.HorseDisciplineRepository;
import com.equestricraft.core.horse.discipline.HorseDisciplineSession;
import com.equestricraft.core.skill.Skill;
import com.equestricraft.featureflag.FeatureFlag;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.executor.GroovyRuleScriptExecutor;
import com.equestricraft.groovy.executor.GroovyScriptResponse;
import com.equestricraft.groovy.executor.RuleScriptResponse;
import com.equestricraft.logging.Log;
import java.util.Date;
import java.util.List;

public class HorseDisciplineSessionImpl
implements HorseDisciplineSession {
    @Service
    private HorseDisciplineRepository horseDisciplineRepository;
    @Service
    private DisciplineRepository disciplineRepository;
    private static final Log log = Log.getLogger(HorseDisciplineSessionImpl.class.getName());

    @Override
    public List<Discipline> certifyHorsesDisciplines(EQHorse horse) {
        List<Discipline> disciplinesHorseHas = this.calculateHorsesDisciplines(horse);
        if (FeatureFlag.DISCIPLINE_CERTIFICATION.isDisabled()) {
            return disciplinesHorseHas;
        }
        List<HorseDiscipline> horseDisciplines = disciplinesHorseHas.stream().map(d -> new HorseDiscipline(horse.getId(), d.getId())).toList();
        this.horseDisciplineRepository.clearHorsesDisciplines(horse.getId());
        this.horseDisciplineRepository.add(horseDisciplines);
        horse.setLastDisciplineCertification(new Date());
        horse.save();
        return disciplinesHorseHas;
    }

    @Override
    public List<Discipline> getHorsesCertifiedDisciplines(EQHorse horse) {
        if (FeatureFlag.DISCIPLINE_CERTIFICATION.isDisabled()) {
            return this.calculateHorsesDisciplines(horse);
        }
        List<HorseDiscipline> horseDisciplines = this.horseDisciplineRepository.findByHorse(horse.getId());
        return horseDisciplines.stream().map(HorseDisciplineAdapter::getDiscipline).toList();
    }

    @Override
    public boolean doesHorseHaveDisciplineCertified(EQHorse horse, Discipline discipline) {
        if (FeatureFlag.DISCIPLINE_CERTIFICATION.isDisabled()) {
            return this.executeDisciplineScript(horse, discipline);
        }
        List<HorseDiscipline> horseDisciplines = this.horseDisciplineRepository.findByHorse(horse.getId());
        return horseDisciplines.stream().map(HorseDisciplineAdapter::getDiscipline).anyMatch(discipline::equals);
    }

    private List<Discipline> calculateHorsesDisciplines(EQHorse horse) {
        return this.disciplineRepository.streamAll().filter(d -> this.doesHorseHaveSkills(horse, (Discipline)d)).filter(d -> this.executeDisciplineScript(horse, (Discipline)d)).toList();
    }

    private boolean doesHorseHaveSkills(EQHorse horse, Discipline discipline) {
        List<Skill> horsesSkills = horse.getSkill().getSkills();
        for (Integer skill : discipline.getSkillIds()) {
            if (!horsesSkills.stream().noneMatch(s -> s.getId() == skill.intValue())) continue;
            return false;
        }
        return true;
    }

    private boolean executeDisciplineScript(EQHorse horse, Discipline discipline) {
        if (discipline.getScript().isBlank()) {
            return true;
        }
        APIHorseDtoImpl horseDto = new APIHorseDtoImpl(horse);
        try {
            GroovyScriptResponse<RuleScriptResponse> response = ((GroovyRuleScriptExecutor)GroovyRuleScriptExecutor.start(discipline.getScript()).withHorse(horseDto)).execute();
            return response.result().success();
        }
        catch (GroovyException ex) {
            log.error("Error executing discipline script", ex);
            return false;
        }
    }
}

