/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.energy;

import com.equestricraft.common.CachedValue;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.restless.RestlessTrait;
import java.time.Duration;

public class HorseEnergyAccessor
extends AbstractHorseAccessor {
    private final CachedValue<Float> energyValue = new CachedValue<Float>(this::getUpdatedLevel, Duration.ofMinutes(2L));

    public HorseEnergyAccessor(EQHorse horse) {
        super(horse);
    }

    public float getLevel() {
        return this.energyValue.get().floatValue();
    }

    public float getUpdatedLevel() {
        long baseMaximum = this.horse.getStamina().getBaseMaximum();
        long currentMaximum = this.horse.getStamina().getCurrentMaximum();
        long energy = currentMaximum / baseMaximum;
        float restless = this.horse.getTraits().getValue(RestlessTrait.class);
        return (float)energy * (restless + 1.0f);
    }
}

