/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.environment;

import com.equestricraft.api.common.APIDurationDto;
import com.equestricraft.api.common.APIHorseEnvironmentDto;
import com.equestricraft.common.EnvironmentType;
import com.equestricraft.core.horse.environment.HorseEnvironmentAccessor;
import groovy.lang.Closure;
import java.time.Duration;

public class APIHorseEnvironmentDtoImpl
implements APIHorseEnvironmentDto {
    private final HorseEnvironmentAccessor horseEnvironmentAccessor;

    public APIHorseEnvironmentDtoImpl(HorseEnvironmentAccessor horseEnvironmentAccessor) {
        this.horseEnvironmentAccessor = horseEnvironmentAccessor;
    }

    @Override
    public String getCurrent() {
        return this.horseEnvironmentAccessor.getCurrent().name();
    }

    @Override
    public APIDurationDto indoorsDuration(Closure<?> closure) {
        APIDurationDto duration = new APIDurationDto();
        closure.setDelegate(duration);
        closure.call();
        Duration total = this.horseEnvironmentAccessor.getDurationInEnvironment(EnvironmentType.INDOOR, duration.getDuration());
        return new APIDurationDto(total);
    }

    @Override
    public APIDurationDto outdoorsDuration(Closure<?> closure) {
        APIDurationDto duration = new APIDurationDto();
        closure.setDelegate(duration);
        closure.call();
        Duration total = this.horseEnvironmentAccessor.getDurationInEnvironment(EnvironmentType.OUTDOOR, duration.getDuration());
        return new APIDurationDto(total);
    }

    @Override
    public boolean isIndoors() {
        return this.horseEnvironmentAccessor.getCurrent() == EnvironmentType.INDOOR;
    }

    @Override
    public boolean isOutdoors() {
        return this.horseEnvironmentAccessor.getCurrent() == EnvironmentType.OUTDOOR;
    }

    public String toString() {
        return this.getCurrent();
    }
}

