/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.environment;

import com.equestricraft.common.EnvironmentType;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.environment.HorseEnvironmentLog;
import java.time.Duration;

public class HorseEnvironmentAccessor
extends AbstractHorseAccessor {
    private final HorseEnvironmentLog log = new HorseEnvironmentLog();
    private EnvironmentType current = EnvironmentType.OUTDOOR;
    private long lastEnvironmentUpdate = 0L;

    public HorseEnvironmentAccessor(EQHorse horse) {
        super(horse);
    }

    public void setCurrentEnvironment(EnvironmentType type) {
        if (DateUtils.secondsSince(this.lastEnvironmentUpdate) > 20) {
            if (this.current != type) {
                this.log.logEnvironmentChange(type);
                this.current = type;
            }
            this.lastEnvironmentUpdate = System.currentTimeMillis();
        }
    }

    public EnvironmentType getCurrent() {
        return this.current;
    }

    public Duration getDurationInEnvironment(EnvironmentType type, Duration duration) {
        return this.log.getDurationForTypeSince(type, DateUtils.futureDurationOffset(duration.negated()));
    }
}

