/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.environment;

import com.equestricraft.common.EnvironmentType;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.StampedLock;

public class HorseEnvironmentLog {
    private final List<LogEntry> entries = new ArrayList<LogEntry>();
    private final StampedLock lock = new StampedLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logEnvironmentChange(EnvironmentType newEnvironment) {
        long stamp = this.lock.writeLock();
        try {
            LogEntry entry = new LogEntry(newEnvironment, new Date());
            this.entries.add(entry);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Duration getDurationForTypeSince(EnvironmentType type, Date since) {
        long stamp = this.lock.readLock();
        try {
            long totalMillis = 0L;
            for (int i = 0; i < this.entries.size(); ++i) {
                LogEntry entry = this.entries.get(i);
                if (entry.type() != type) continue;
                Date effectiveEntryStartTime = entry.time().before(since) ? since : entry.time();
                Optional next = this.entries.size() - 1 > i ? Optional.of(this.entries.get(i)) : Optional.empty();
                Date effectiveEndTime = next.isPresent() && ((LogEntry)next.get()).time().after(since) ? ((LogEntry)next.get()).time() : new Date();
                long millis = effectiveEndTime.getTime() - effectiveEntryStartTime.getTime();
                totalMillis += millis;
            }
            Duration duration = Duration.ofMillis(totalMillis);
            return duration;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    private record LogEntry(EnvironmentType type, Date time) {
    }
}

