/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.frustration;

import com.equestricraft.common.util.DateUtils;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import java.util.concurrent.atomic.AtomicReference;

public class HorseFrustrationAccessor
extends AbstractHorseAccessor {
    private final AtomicReference<Float> value = new AtomicReference<Float>(Float.valueOf(0.0f));
    private long lastReduction = 0L;

    public HorseFrustrationAccessor(EQHorse horse) {
        super(horse);
    }

    @Override
    public void activeTick() {
        if (DateUtils.secondsSince(this.lastReduction) < 5) {
            return;
        }
        this.decrement(0.01f);
        this.lastReduction = System.currentTimeMillis();
    }

    public float getValue() {
        return this.value.get().floatValue();
    }

    public void increment(float amount) {
        this.value.accumulateAndGet(Float.valueOf(amount), (current, toAdd) -> Float.valueOf(Math.min(current.floatValue() + toAdd.floatValue(), 1.0f)));
    }

    public void decrement(float amount) {
        this.value.accumulateAndGet(Float.valueOf(amount), (current, toAdd) -> Float.valueOf(Math.max(current.floatValue() - toAdd.floatValue(), 0.0f)));
    }

    public void setValue(float value) {
        value = NumberUtils.keepWithinRange(Float.valueOf(value), Float.valueOf(0.0f), Float.valueOf(1.0f)).floatValue();
        this.value.set(Float.valueOf(value));
    }
}

